/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingleold.provider;

import java.io.IOException;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.jingleold.media.PayloadType;
import org.jivesoftware.smackx.jingleold.packet.JingleContentDescription;
import org.jxmpp.JxmppContext;

public abstract class JingleContentDescriptionProvider
extends ExtensionElementProvider<JingleContentDescription> {
    protected JingleContentDescription.JinglePayloadType parsePayload(XmlPullParser parser) {
        int ptId = Integer.parseInt(parser.getAttributeValue("", "id"));
        String ptName = parser.getAttributeValue("", "name");
        int ptChannels = Integer.parseInt(parser.getAttributeValue("", "channels"));
        return new JingleContentDescription.JinglePayloadType(new PayloadType(ptId, ptName, ptChannels));
    }

    public JingleContentDescription parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
        JingleContentDescription desc = this.getInstance();
        while (true) {
            XmlPullParser.Event eventType;
            if ((eventType = parser.next()) == XmlPullParser.Event.START_ELEMENT) {
                String name = parser.getName();
                if (name.equals("payload-type")) {
                    desc.addJinglePayloadType(this.parsePayload(parser));
                    continue;
                }
                throw new IOException("Unknow element \"" + name + "\" in content.");
            }
            if (eventType == XmlPullParser.Event.END_ELEMENT && parser.getDepth() == initialDepth) break;
        }
        return desc;
    }

    protected abstract JingleContentDescription getInstance();

    public static class Audio
    extends JingleContentDescriptionProvider {
        @Override
        public JingleContentDescription.JinglePayloadType parsePayload(XmlPullParser parser) {
            JingleContentDescription.JinglePayloadType pte = super.parsePayload(parser);
            PayloadType.Audio pt = new PayloadType.Audio(pte.getPayloadType());
            int ptClockRate = Integer.parseInt(parser.getAttributeValue("", "clockrate"));
            pt.setClockRate(ptClockRate);
            return new JingleContentDescription.JinglePayloadType.Audio(pt);
        }

        @Override
        protected JingleContentDescription getInstance() {
            return new JingleContentDescription.Audio();
        }
    }
}

