/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.JingleSessionRequest;
import org.jivesoftware.smackx.jingle.listeners.CreatedJingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionListener;
import org.jivesoftware.smackx.jingle.listeners.JingleSessionRequestListener;
import org.jivesoftware.smackx.jingle.media.JingleMediaManager;
import org.jivesoftware.smackx.jingle.media.PayloadType;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.packet.Jingle;
import org.jivesoftware.smackx.jingle.provider.JingleProvider;

public class JingleManager
implements JingleSessionListener {
    private static final Logger LOGGER = Logger.getLogger(JingleManager.class.getName());
    final List<JingleSession> jingleSessions = new ArrayList<JingleSession>();
    private List<JingleSessionRequestListener> jingleSessionRequestListeners;
    private List<CreatedJingleSessionListener> creationListeners = new ArrayList<CreatedJingleSessionListener>();
    private XMPPConnection connection;
    private List<JingleMediaManager> jingleMediaManagers;

    public JingleManager(XMPPConnection connection, List<JingleMediaManager> jingleMediaManagers) throws XMPPException, SmackException {
        this.connection = connection;
        this.jingleMediaManagers = jingleMediaManagers;
        connection.getRoster().addRosterListener(new RosterListener(){

            public void entriesAdded(Collection<String> addresses) {
            }

            public void entriesUpdated(Collection<String> addresses) {
            }

            public void entriesDeleted(Collection<String> addresses) {
            }

            public void presenceChanged(Presence presence) {
                if (!presence.isAvailable()) {
                    String xmppAddress = presence.getFrom();
                    JingleSession aux = null;
                    for (JingleSession jingleSession : JingleManager.this.jingleSessions) {
                        if (!jingleSession.getInitiator().equals(xmppAddress) && !jingleSession.getResponder().equals(xmppAddress)) continue;
                        aux = jingleSession;
                    }
                    if (aux != null) {
                        try {
                            aux.terminate();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    public static void setJingleServiceEnabled() {
        ProviderManager.addIQProvider((String)"jingle", (String)"urn:xmpp:tmp:jingle", (Object)new JingleProvider());
        XMPPConnection.addConnectionCreationListener((ConnectionCreationListener)new ConnectionCreationListener(){

            public void connectionCreated(XMPPConnection connection) {
                JingleManager.setServiceEnabled(connection, true);
            }
        });
    }

    public static synchronized void setServiceEnabled(XMPPConnection connection, boolean enabled) {
        if (JingleManager.isServiceEnabled(connection) == enabled) {
            return;
        }
        if (enabled) {
            ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).addFeature("urn:xmpp:tmp:jingle");
        } else {
            ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).removeFeature("urn:xmpp:tmp:jingle");
        }
    }

    public static boolean isServiceEnabled(XMPPConnection connection) {
        return ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).includesFeature("urn:xmpp:tmp:jingle");
    }

    public static boolean isServiceEnabled(XMPPConnection connection, String userID) throws XMPPException, SmackException {
        return ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection).supportsFeature(userID, "urn:xmpp:tmp:jingle");
    }

    public List<JingleMediaManager> getMediaManagers() {
        return this.jingleMediaManagers;
    }

    public void setMediaManagers(List<JingleMediaManager> jingleMediaManagers) {
        this.jingleMediaManagers = jingleMediaManagers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addJingleSessionRequestListener(JingleSessionRequestListener jingleSessionRequestListener) {
        if (jingleSessionRequestListener != null) {
            if (this.jingleSessionRequestListeners == null) {
                this.initJingleSessionRequestListeners();
            }
            List<JingleSessionRequestListener> list = this.jingleSessionRequestListeners;
            synchronized (list) {
                this.jingleSessionRequestListeners.add(jingleSessionRequestListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeJingleSessionRequestListener(JingleSessionRequestListener jingleSessionRequestListener) {
        if (this.jingleSessionRequestListeners == null) {
            return;
        }
        List<JingleSessionRequestListener> list = this.jingleSessionRequestListeners;
        synchronized (list) {
            this.jingleSessionRequestListeners.remove(jingleSessionRequestListener);
        }
    }

    public void addCreationListener(CreatedJingleSessionListener createdJingleSessionListener) {
        this.creationListeners.add(createdJingleSessionListener);
    }

    public void removeCreationListener(CreatedJingleSessionListener createdJingleSessionListener) {
        this.creationListeners.remove(createdJingleSessionListener);
    }

    public void triggerSessionCreated(JingleSession jingleSession) {
        this.jingleSessions.add(jingleSession);
        jingleSession.addListener(this);
        for (CreatedJingleSessionListener createdJingleSessionListener : this.creationListeners) {
            try {
                createdJingleSessionListener.sessionCreated(jingleSession);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void sessionEstablished(PayloadType pt, TransportCandidate rc, TransportCandidate lc, JingleSession jingleSession) {
    }

    @Override
    public void sessionDeclined(String reason, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
        jingleSession.close();
        LOGGER.severe("Declined:" + reason);
    }

    @Override
    public void sessionRedirected(String redirection, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionClosed(String reason, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionClosedOnError(XMPPException e, JingleSession jingleSession) {
        jingleSession.removeListener(this);
        this.jingleSessions.remove(jingleSession);
    }

    @Override
    public void sessionMediaReceived(JingleSession jingleSession, String participant) {
    }

    private void initJingleSessionRequestListeners() {
        PacketFilter initRequestFilter = new PacketFilter(){

            public boolean accept(Packet pin) {
                Jingle jin;
                IQ iq;
                return pin instanceof IQ && (iq = (IQ)pin).getType().equals(IQ.Type.SET) && iq instanceof Jingle && (jin = (Jingle)pin).getAction().equals((Object)JingleActionEnum.SESSION_INITIATE);
            }
        };
        this.jingleSessionRequestListeners = new ArrayList<JingleSessionRequestListener>();
        this.connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                JingleManager.this.triggerSessionRequested((Jingle)packet);
            }
        }, initRequestFilter);
    }

    public void disconnectAllSessions() {
        List<JingleSession> sessions = this.jingleSessions.subList(0, this.jingleSessions.size());
        for (JingleSession jingleSession : sessions) {
            try {
                jingleSession.terminate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        sessions.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void triggerSessionRequested(Jingle initJin) {
        JingleSessionRequestListener[] jingleSessionRequestListeners = null;
        List<JingleSessionRequestListener> list = this.jingleSessionRequestListeners;
        synchronized (list) {
            jingleSessionRequestListeners = new JingleSessionRequestListener[this.jingleSessionRequestListeners.size()];
            this.jingleSessionRequestListeners.toArray(jingleSessionRequestListeners);
        }
        JingleSessionRequest request = new JingleSessionRequest(this, initJin);
        for (int i = 0; i < jingleSessionRequestListeners.length; ++i) {
            jingleSessionRequestListeners[i].sessionRequested(request);
        }
    }

    public JingleSession createOutgoingJingleSession(String responder) throws XMPPException {
        if (responder == null || StringUtils.parseName((String)responder).length() <= 0 || StringUtils.parseServer((String)responder).length() <= 0 || StringUtils.parseResource((String)responder).length() <= 0) {
            throw new IllegalArgumentException("The provided user id was not fully qualified");
        }
        JingleSession session = new JingleSession(this.connection, (JingleSessionRequest)null, this.connection.getUser(), responder, this.jingleMediaManagers);
        this.triggerSessionCreated(session);
        return session;
    }

    public JingleSession createIncomingJingleSession(JingleSessionRequest request) throws XMPPException {
        if (request == null) {
            throw new NullPointerException("Received request cannot be null");
        }
        JingleSession session = new JingleSession(this.connection, request, request.getFrom(), this.connection.getUser(), this.jingleMediaManagers);
        this.triggerSessionCreated(session);
        return session;
    }

    public JingleSession getSession(String jid) {
        for (JingleSession jingleSession : this.jingleSessions) {
            if (!jingleSession.getResponder().equals(jid)) continue;
            return jingleSession;
        }
        return null;
    }
}

