/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleManager;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.packet.Jingle;

public class JingleSessionRequest {
    private static final Logger LOGGER = Logger.getLogger(JingleSessionRequest.class.getName());
    private final Jingle jingle;
    private final JingleManager manager;

    public JingleSessionRequest(JingleManager manager, Jingle jingle) {
        this.manager = manager;
        this.jingle = jingle;
    }

    public String getFrom() {
        return this.jingle.getFrom();
    }

    public String getSessionID() {
        return this.jingle.getSid();
    }

    public Jingle getJingle() {
        return this.jingle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JingleSession accept() throws XMPPException, SmackException {
        JingleSession session = null;
        JingleManager jingleManager = this.manager;
        synchronized (jingleManager) {
            session = this.manager.createIncomingJingleSession(this);
            session.setSid(this.getSessionID());
            session.updatePacketListener();
            session.receivePacketAndRespond(this.getJingle());
        }
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reject() {
        JingleSession session = null;
        JingleManager jingleManager = this.manager;
        synchronized (jingleManager) {
            try {
                session = this.manager.createIncomingJingleSession(this);
                session.setSid(this.getSessionID());
                session.updatePacketListener();
                session.terminate("Declined");
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception in reject", e);
            }
        }
    }
}

