/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle;

import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.JingleSessionState;
import org.jivesoftware.smackx.jingle.JingleSessionStateActive;
import org.jivesoftware.smackx.jingle.packet.Jingle;

public class JingleSessionStatePending
extends JingleSessionState {
    private static JingleSessionStatePending INSTANCE = null;

    protected JingleSessionStatePending() {
    }

    public static synchronized JingleSessionState getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JingleSessionStatePending();
        }
        return INSTANCE;
    }

    @Override
    public void enter() {
    }

    @Override
    public void exit() {
    }

    @Override
    public IQ processJingle(JingleSession session, Jingle jingle, JingleActionEnum action) {
        IQ response = null;
        switch (action) {
            case CONTENT_ACCEPT: {
                response = this.receiveContentAcceptAction(jingle);
                break;
            }
            case CONTENT_MODIFY: {
                break;
            }
            case CONTENT_REMOVE: {
                break;
            }
            case SESSION_ACCEPT: {
                response = this.receiveSessionAcceptAction(session, jingle);
                break;
            }
            case SESSION_INFO: {
                break;
            }
            case SESSION_TERMINATE: {
                response = this.receiveSessionTerminateAction(session, jingle);
                break;
            }
            case TRANSPORT_INFO: {
                break;
            }
        }
        return response;
    }

    private IQ receiveContentAcceptAction(Jingle inJingle) {
        return null;
    }

    private IQ receiveSessionAcceptAction(JingleSession session, Jingle inJingle) {
        session.setSessionState(JingleSessionStateActive.getInstance());
        return session.createAck(inJingle);
    }

    private IQ receiveSessionTerminateAction(JingleSession session, Jingle jingle) {
        IQ response = session.createAck(jingle);
        try {
            session.terminate("Closed remotely");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return response;
    }
}

