/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.provider;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.jingle.JingleActionEnum;
import org.jivesoftware.smackx.jingle.packet.Jingle;
import org.jivesoftware.smackx.jingle.packet.JingleContent;
import org.jivesoftware.smackx.jingle.packet.JingleContentInfo;
import org.jivesoftware.smackx.jingle.packet.JingleDescription;
import org.jivesoftware.smackx.jingle.packet.JingleTransport;
import org.jivesoftware.smackx.jingle.provider.JingleContentInfoProvider;
import org.jivesoftware.smackx.jingle.provider.JingleContentProvider;
import org.jivesoftware.smackx.jingle.provider.JingleDescriptionProvider;
import org.jivesoftware.smackx.jingle.provider.JingleTransportProvider;
import org.xmlpull.v1.XmlPullParser;

public class JingleProvider
implements IQProvider {
    public IQ parseIQ(XmlPullParser parser) throws Exception {
        Jingle jingle = new Jingle();
        String sid = "";
        String initiator = "";
        String responder = "";
        boolean done = false;
        JingleContent currentContent = null;
        JingleContentProvider jcp = new JingleContentProvider();
        JingleDescriptionProvider.Audio jdpAudio = new JingleDescriptionProvider.Audio();
        JingleTransportProvider.RawUdp jtpRawUdp = new JingleTransportProvider.RawUdp();
        JingleTransportProvider.Ice jtpIce = new JingleTransportProvider.Ice();
        JingleContentInfoProvider.Audio jmipAudio = new JingleContentInfoProvider.Audio();
        sid = parser.getAttributeValue("", "sid");
        JingleActionEnum action = JingleActionEnum.getAction(parser.getAttributeValue("", "action"));
        initiator = parser.getAttributeValue("", "initiator");
        responder = parser.getAttributeValue("", "responder");
        jingle.setSid(sid);
        jingle.setAction(action);
        jingle.setInitiator(initiator);
        jingle.setResponder(responder);
        while (!done) {
            int eventType = parser.next();
            String elementName = parser.getName();
            String namespace = parser.getNamespace();
            if (eventType == 2) {
                if (elementName.equals("content")) {
                    currentContent = (JingleContent)jcp.parseExtension(parser);
                    jingle.addContent(currentContent);
                    continue;
                }
                if (elementName.equals("description") && namespace.equals("urn:xmpp:tmp:jingle:apps:rtp")) {
                    currentContent.setDescription((JingleDescription)jdpAudio.parseExtension(parser));
                    continue;
                }
                if (elementName.equals("transport")) {
                    if (namespace.equals("http://www.xmpp.org/extensions/xep-0177.html#ns")) {
                        currentContent.addJingleTransport((JingleTransport)jtpRawUdp.parseExtension(parser));
                        continue;
                    }
                    if (namespace.equals("urn:xmpp:tmp:jingle:transports:ice-udp")) {
                        currentContent.addJingleTransport((JingleTransport)jtpIce.parseExtension(parser));
                        continue;
                    }
                    throw new SmackException("Unknown transport namespace \"" + namespace + "\" in Jingle packet.");
                }
                if (namespace.equals("urn:xmpp:tmp:jingle:apps:rtp")) {
                    jingle.setContentInfo((JingleContentInfo)((JingleContentInfoProvider)jmipAudio).parseExtension(parser));
                    continue;
                }
                throw new SmackException("Unknown combination of namespace \"" + namespace + "\" and element name \"" + elementName + "\" in Jingle packet.");
            }
            if (eventType != 3 || !parser.getName().equals(Jingle.getElementName())) continue;
            done = true;
        }
        return jingle;
    }
}

