/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.xmlpull.v1.XmlPullParser;

public class RTPBridge
extends IQ {
    private static final Logger LOGGER = Logger.getLogger(RTPBridge.class.getName());
    private String sid;
    private String pass;
    private String ip;
    private String name;
    private int portA = -1;
    private int portB = -1;
    private String hostA;
    private String hostB;
    private BridgeAction bridgeAction = BridgeAction.create;
    public static final String NAME = "rtpbridge";
    public static final String ELEMENT_NAME = "rtpbridge";
    public static final String NAMESPACE = "http://www.jivesoftware.com/protocol/rtpbridge";

    public RTPBridge(String sid) {
        this.sid = sid;
    }

    public RTPBridge(BridgeAction action) {
        this.bridgeAction = action;
    }

    public RTPBridge(String sid, BridgeAction bridgeAction) {
        this.sid = sid;
        this.bridgeAction = bridgeAction;
    }

    public RTPBridge() {
    }

    public String getAttributes() {
        StringBuilder str = new StringBuilder();
        if (this.getSid() != null) {
            str.append(" sid='").append(this.getSid()).append("'");
        }
        if (this.getPass() != null) {
            str.append(" pass='").append(this.getPass()).append("'");
        }
        if (this.getPortA() != -1) {
            str.append(" porta='").append(this.getPortA()).append("'");
        }
        if (this.getPortB() != -1) {
            str.append(" portb='").append(this.getPortB()).append("'");
        }
        if (this.getHostA() != null) {
            str.append(" hosta='").append(this.getHostA()).append("'");
        }
        if (this.getHostB() != null) {
            str.append(" hostb='").append(this.getHostB()).append("'");
        }
        return str.toString();
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }

    public String getHostA() {
        return this.hostA;
    }

    public void setHostA(String hostA) {
        this.hostA = hostA;
    }

    public String getHostB() {
        return this.hostB;
    }

    public void setHostB(String hostB) {
        this.hostB = hostB;
    }

    public int getPortA() {
        return this.portA;
    }

    public void setPortA(int portA) {
        this.portA = portA;
    }

    public int getPortB() {
        return this.portB;
    }

    public void setPortB(int portB) {
        this.portB = portB;
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getChildElementXML() {
        StringBuilder str = new StringBuilder();
        str.append("<rtpbridge xmlns='http://www.jivesoftware.com/protocol/rtpbridge' sid='").append(this.sid).append("'>");
        if (this.bridgeAction.equals((Object)BridgeAction.create)) {
            str.append("<candidate/>");
        } else if (this.bridgeAction.equals((Object)BridgeAction.change)) {
            str.append("<relay ").append(this.getAttributes()).append(" />");
        } else {
            str.append("<publicip ").append(this.getAttributes()).append(" />");
        }
        str.append("</rtpbridge>");
        return str.toString();
    }

    public static RTPBridge getRTPBridge(XMPPConnection connection, String sessionID) throws SmackException.NotConnectedException {
        if (!connection.isConnected()) {
            return null;
        }
        RTPBridge rtpPacket = new RTPBridge(sessionID);
        rtpPacket.setTo("rtpbridge." + connection.getServiceName());
        PacketCollector collector = connection.createPacketCollectorAndSend((IQ)rtpPacket);
        RTPBridge response = (RTPBridge)collector.nextResult();
        collector.cancel();
        return response;
    }

    public static boolean serviceAvailable(XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (!connection.isConnected()) {
            return false;
        }
        LOGGER.fine("Service listing");
        ServiceDiscoveryManager disco = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)connection);
        DiscoverInfo discoInfo = disco.discoverInfo(connection.getServiceName());
        for (DiscoverInfo.Identity identity : discoInfo.getIdentities()) {
            if (identity.getName() == null || !identity.getName().startsWith("rtpbridge")) continue;
            return true;
        }
        return false;
    }

    public static RTPBridge relaySession(XMPPConnection connection, String sessionID, String pass, TransportCandidate proxyCandidate, TransportCandidate localCandidate) throws SmackException.NotConnectedException {
        if (!connection.isConnected()) {
            return null;
        }
        RTPBridge rtpPacket = new RTPBridge(sessionID, BridgeAction.change);
        rtpPacket.setTo("rtpbridge." + connection.getServiceName());
        rtpPacket.setType(IQ.Type.SET);
        rtpPacket.setPass(pass);
        rtpPacket.setPortA(localCandidate.getPort());
        rtpPacket.setPortB(proxyCandidate.getPort());
        rtpPacket.setHostA(localCandidate.getIp());
        rtpPacket.setHostB(proxyCandidate.getIp());
        PacketCollector collector = connection.createPacketCollectorAndSend((IQ)rtpPacket);
        RTPBridge response = (RTPBridge)collector.nextResult();
        collector.cancel();
        return response;
    }

    public static String getPublicIP(XMPPConnection xmppConnection) throws SmackException.NotConnectedException {
        if (!xmppConnection.isConnected()) {
            return null;
        }
        RTPBridge rtpPacket = new RTPBridge(BridgeAction.publicip);
        rtpPacket.setTo("rtpbridge." + xmppConnection.getServiceName());
        rtpPacket.setType(IQ.Type.SET);
        PacketCollector collector = xmppConnection.createPacketCollectorAndSend((IQ)rtpPacket);
        RTPBridge response = (RTPBridge)collector.nextResult();
        collector.cancel();
        if (response == null) {
            return null;
        }
        if (response.getIp() == null || response.getIp().equals("")) {
            return null;
        }
        Enumeration<NetworkInterface> ifaces = null;
        try {
            ifaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        while (ifaces != null && ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            Enumeration<InetAddress> iaddresses = iface.getInetAddresses();
            while (iaddresses.hasMoreElements()) {
                InetAddress iaddress = iaddresses.nextElement();
                if (iaddress.isLoopbackAddress() || iaddress.getHostAddress().indexOf(response.getIp()) < 0) continue;
                return null;
            }
        }
        return response.getIp();
    }

    static {
        ProviderManager.addIQProvider((String)"rtpbridge", (String)NAMESPACE, (Object)new Provider());
    }

    public static class Provider
    implements IQProvider {
        public IQ parseIQ(XmlPullParser parser) throws Exception {
            int i;
            boolean done = false;
            if (!parser.getNamespace().equals(RTPBridge.NAMESPACE)) {
                throw new Exception("Not a RTP Bridge packet");
            }
            RTPBridge iq = new RTPBridge();
            for (i = 0; i < parser.getAttributeCount(); ++i) {
                if (!parser.getAttributeName(i).equals("sid")) continue;
                iq.setSid(parser.getAttributeValue(i));
            }
            while (!done) {
                int eventType = parser.next();
                String elementName = parser.getName();
                if (eventType == 2) {
                    if (elementName.equals("candidate")) {
                        for (i = 0; i < parser.getAttributeCount(); ++i) {
                            if (parser.getAttributeName(i).equals("ip")) {
                                iq.setIp(parser.getAttributeValue(i));
                                continue;
                            }
                            if (parser.getAttributeName(i).equals("pass")) {
                                iq.setPass(parser.getAttributeValue(i));
                                continue;
                            }
                            if (parser.getAttributeName(i).equals("name")) {
                                iq.setName(parser.getAttributeValue(i));
                                continue;
                            }
                            if (parser.getAttributeName(i).equals("porta")) {
                                iq.setPortA(Integer.parseInt(parser.getAttributeValue(i)));
                                continue;
                            }
                            if (!parser.getAttributeName(i).equals("portb")) continue;
                            iq.setPortB(Integer.parseInt(parser.getAttributeValue(i)));
                        }
                        continue;
                    }
                    if (!elementName.equals("publicip")) continue;
                    for (i = 0; i < parser.getAttributeCount(); ++i) {
                        if (!parser.getAttributeName(i).equals("ip")) continue;
                        iq.setIp(parser.getAttributeValue(i));
                    }
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("rtpbridge")) continue;
                done = true;
            }
            return iq;
        }
    }

    private static enum BridgeAction {
        create,
        change,
        publicip;

    }
}

