/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.jingle.nat;

import de.javawi.jstun.test.demo.ice.Candidate;
import de.javawi.jstun.test.demo.ice.ICENegociator;
import de.javawi.jstun.util.UtilityException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.jingle.JingleSession;
import org.jivesoftware.smackx.jingle.nat.BridgedResolver;
import org.jivesoftware.smackx.jingle.nat.ICECandidate;
import org.jivesoftware.smackx.jingle.nat.RTPBridge;
import org.jivesoftware.smackx.jingle.nat.TransportCandidate;
import org.jivesoftware.smackx.jingle.nat.TransportResolver;

public class ICEResolver
extends TransportResolver {
    private static final Logger LOGGER = Logger.getLogger(ICEResolver.class.getName());
    XMPPConnection connection;
    Random random = new Random();
    long sid;
    String server;
    int port;
    static Map<String, ICENegociator> negociatorsMap = new HashMap<String, ICENegociator>();

    public ICEResolver(XMPPConnection connection, String server, int port) {
        this.connection = connection;
        this.server = server;
        this.port = port;
        this.setType(TransportResolver.Type.ice);
    }

    @Override
    public void initialize() throws XMPPException {
        if (!this.isResolving() && !this.isResolved()) {
            LOGGER.fine("Initialized");
            if (negociatorsMap.get(this.server) == null) {
                ICENegociator iceNegociator = new ICENegociator(this.server, this.port, 1);
                negociatorsMap.put(this.server, iceNegociator);
                iceNegociator.gatherCandidateAddresses();
                iceNegociator.prioritizeCandidates();
            }
        }
        this.setInitialized();
    }

    @Override
    public void cancel() throws XMPPException {
    }

    @Override
    public synchronized void resolve(JingleSession session) throws XMPPException, SmackException {
        this.setResolveInit();
        for (TransportCandidate candidate : this.getCandidatesList()) {
            if (!(candidate instanceof ICECandidate)) continue;
            ICECandidate iceCandidate = (ICECandidate)candidate;
            iceCandidate.removeCandidateEcho();
        }
        this.clear();
        ICENegociator iceNegociator = negociatorsMap.get(this.server);
        for (Candidate candidate : iceNegociator.getSortedCandidates()) {
            try {
                Candidate.CandidateType type = candidate.getCandidateType();
                ICECandidate.Type iceType = ICECandidate.Type.local;
                iceType = type.equals((Object)Candidate.CandidateType.ServerReflexive) ? ICECandidate.Type.srflx : (type.equals((Object)Candidate.CandidateType.PeerReflexive) ? ICECandidate.Type.prflx : (type.equals((Object)Candidate.CandidateType.Relayed) ? ICECandidate.Type.relay : ICECandidate.Type.host));
                int nicNum = 0;
                try {
                    Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
                    int i = 0;
                    NetworkInterface nic = NetworkInterface.getByInetAddress(candidate.getAddress().getInetAddress());
                    while (nics.hasMoreElements()) {
                        NetworkInterface checkNIC = nics.nextElement();
                        if (checkNIC.equals(nic)) {
                            nicNum = i;
                            break;
                        }
                        i = (short)(i + 1);
                    }
                }
                catch (SocketException e1) {
                    e1.printStackTrace();
                }
                ICECandidate transportCandidate = new ICECandidate(candidate.getAddress().getInetAddress().getHostAddress(), 1, nicNum, String.valueOf(Math.abs(this.random.nextLong())), candidate.getPort(), "1", candidate.getPriority(), iceType);
                transportCandidate.setLocalIp(candidate.getBase().getAddress().getInetAddress().getHostAddress());
                transportCandidate.setPort(this.getFreePort());
                try {
                    transportCandidate.addCandidateEcho(session);
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                this.addCandidate(transportCandidate);
                LOGGER.fine("Candidate addr: " + candidate.getAddress().getInetAddress() + "|" + candidate.getBase().getAddress().getInetAddress() + " Priority:" + candidate.getPriority());
            }
            catch (UtilityException e) {
                e.printStackTrace();
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
        }
        if (RTPBridge.serviceAvailable(this.connection)) {
            String localIp = BridgedResolver.getLocalHost();
            int network = 0;
            this.sid = Math.abs(this.random.nextLong());
            RTPBridge rtpBridge = RTPBridge.getRTPBridge(this.connection, String.valueOf(this.sid));
            ICECandidate localCandidate = new ICECandidate(rtpBridge.getIp(), 1, network, String.valueOf(Math.abs(this.random.nextLong())), rtpBridge.getPortA(), "1", 0, ICECandidate.Type.relay);
            localCandidate.setLocalIp(localIp);
            ICECandidate remoteCandidate = new ICECandidate(rtpBridge.getIp(), 1, network, String.valueOf(Math.abs(this.random.nextLong())), rtpBridge.getPortB(), "1", 0, ICECandidate.Type.relay);
            remoteCandidate.setLocalIp(localIp);
            localCandidate.setSymmetric(remoteCandidate);
            remoteCandidate.setSymmetric(localCandidate);
            localCandidate.setPassword(rtpBridge.getPass());
            remoteCandidate.setPassword(rtpBridge.getPass());
            localCandidate.setSessionId(rtpBridge.getSid());
            remoteCandidate.setSessionId(rtpBridge.getSid());
            localCandidate.setConnection(this.connection);
            remoteCandidate.setConnection(this.connection);
            this.addCandidate(localCandidate);
            String publicIp = RTPBridge.getPublicIP(this.connection);
            if (publicIp != null && !publicIp.equals("")) {
                Enumeration<NetworkInterface> ifaces = null;
                try {
                    ifaces = NetworkInterface.getNetworkInterfaces();
                }
                catch (SocketException e) {
                    e.printStackTrace();
                }
                boolean found = false;
                block16: while (ifaces.hasMoreElements()) {
                    NetworkInterface iface = ifaces.nextElement();
                    Enumeration<InetAddress> iaddresses = iface.getInetAddresses();
                    while (iaddresses.hasMoreElements()) {
                        InetAddress iaddress = iaddresses.nextElement();
                        if (iaddress.getHostAddress().indexOf(publicIp) <= -1) continue;
                        found = true;
                        continue block16;
                    }
                }
                if (!found) {
                    try {
                        ICECandidate publicCandidate = new ICECandidate(publicIp, 1, 0, String.valueOf(Math.abs(this.random.nextLong())), this.getFreePort(), "1", 0, ICECandidate.Type.srflx);
                        publicCandidate.setLocalIp(InetAddress.getLocalHost().getHostAddress());
                        try {
                            publicCandidate.addCandidateEcho(session);
                        }
                        catch (SocketException e) {
                            e.printStackTrace();
                        }
                        this.addCandidate(publicCandidate);
                    }
                    catch (UnknownHostException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.setResolveEnd();
    }
}

