/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.Collection;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smackx.workgroup.packet.AgentInfo;
import org.jivesoftware.smackx.workgroup.packet.AgentWorkgroups;

public class Agent {
    private XMPPConnection connection;
    private String workgroupJID;

    public static Collection<String> getWorkgroups(String serviceJID, String agentJID, XMPPConnection connection) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        AgentWorkgroups request = new AgentWorkgroups(agentJID);
        request.setTo(serviceJID);
        AgentWorkgroups response = (AgentWorkgroups)connection.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        return response.getWorkgroups();
    }

    Agent(XMPPConnection connection, String workgroupJID) {
        this.connection = connection;
        this.workgroupJID = workgroupJID;
    }

    public String getUser() {
        return this.connection.getUser();
    }

    public String getName() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.setType(IQ.Type.GET);
        agentInfo.setTo(this.workgroupJID);
        agentInfo.setFrom(this.getUser());
        AgentInfo response = (AgentInfo)this.connection.createPacketCollectorAndSend((IQ)agentInfo).nextResultOrThrow();
        return response.getName();
    }

    public void setName(String newName) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        AgentInfo agentInfo = new AgentInfo();
        agentInfo.setType(IQ.Type.SET);
        agentInfo.setTo(this.workgroupJID);
        agentInfo.setFrom(this.getUser());
        agentInfo.setName(newName);
        this.connection.createPacketCollectorAndSend((IQ)agentInfo).nextResultOrThrow();
    }
}

