/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.user;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromMatchesFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.packet.MUCUser;
import org.jivesoftware.smackx.workgroup.MetaData;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitation;
import org.jivesoftware.smackx.workgroup.WorkgroupInvitationListener;
import org.jivesoftware.smackx.workgroup.ext.forms.WorkgroupForm;
import org.jivesoftware.smackx.workgroup.packet.DepartQueuePacket;
import org.jivesoftware.smackx.workgroup.packet.QueueUpdate;
import org.jivesoftware.smackx.workgroup.packet.SessionID;
import org.jivesoftware.smackx.workgroup.packet.UserID;
import org.jivesoftware.smackx.workgroup.settings.ChatSetting;
import org.jivesoftware.smackx.workgroup.settings.ChatSettings;
import org.jivesoftware.smackx.workgroup.settings.OfflineSettings;
import org.jivesoftware.smackx.workgroup.settings.SoundSettings;
import org.jivesoftware.smackx.workgroup.settings.WorkgroupProperties;
import org.jivesoftware.smackx.workgroup.user.QueueListener;
import org.jivesoftware.smackx.xdata.Form;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.packet.DataForm;

public class Workgroup {
    private String workgroupJID;
    private XMPPConnection connection;
    private boolean inQueue;
    private List<WorkgroupInvitationListener> invitationListeners;
    private List<QueueListener> queueListeners;
    private int queuePosition = -1;
    private int queueRemainingTime = -1;

    public Workgroup(String workgroupJID, XMPPConnection connection) {
        if (!connection.isAuthenticated()) {
            throw new IllegalStateException("Must login to server before creating workgroup.");
        }
        this.workgroupJID = workgroupJID;
        this.connection = connection;
        this.inQueue = false;
        this.invitationListeners = new ArrayList<WorkgroupInvitationListener>();
        this.queueListeners = new ArrayList<QueueListener>();
        this.addQueueListener(new QueueListener(){

            @Override
            public void joinedQueue() {
                Workgroup.this.inQueue = true;
            }

            @Override
            public void departedQueue() {
                Workgroup.this.inQueue = false;
                Workgroup.this.queuePosition = -1;
                Workgroup.this.queueRemainingTime = -1;
            }

            @Override
            public void queuePositionUpdated(int currentPosition) {
                Workgroup.this.queuePosition = currentPosition;
            }

            @Override
            public void queueWaitTimeUpdated(int secondsRemaining) {
                Workgroup.this.queueRemainingTime = secondsRemaining;
            }
        });
        MultiUserChat.addInvitationListener((XMPPConnection)connection, (InvitationListener)new InvitationListener(){

            public void invitationReceived(XMPPConnection conn, String room, String inviter, String reason, String password, Message message) {
                Workgroup.this.inQueue = false;
                Workgroup.this.queuePosition = -1;
                Workgroup.this.queueRemainingTime = -1;
            }
        });
        PacketTypeFilter typeFilter = new PacketTypeFilter(Message.class);
        connection.addPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Workgroup.this.handlePacket(packet);
            }
        }, (PacketFilter)typeFilter);
    }

    public String getWorkgroupJID() {
        return this.workgroupJID;
    }

    public boolean isInQueue() {
        return this.inQueue;
    }

    public boolean isAvailable() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        Presence directedPresence = new Presence(Presence.Type.available);
        directedPresence.setTo(this.workgroupJID);
        PacketTypeFilter typeFilter = new PacketTypeFilter(Presence.class);
        FromMatchesFilter fromFilter = FromMatchesFilter.create((String)this.workgroupJID);
        PacketCollector collector = this.connection.createPacketCollector((PacketFilter)new AndFilter(new PacketFilter[]{fromFilter, typeFilter}));
        this.connection.sendPacket((Packet)directedPresence);
        Presence response = (Presence)collector.nextResultOrThrow();
        return Presence.Type.available == response.getType();
    }

    public int getQueuePosition() {
        return this.queuePosition;
    }

    public int getQueueRemainingTime() {
        return this.queueRemainingTime;
    }

    public void joinQueue() throws XMPPException, SmackException {
        this.joinQueue(null);
    }

    public void joinQueue(Form answerForm) throws XMPPException, SmackException {
        this.joinQueue(answerForm, null);
    }

    public void joinQueue(Form answerForm, String userID) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (this.inQueue) {
            throw new IllegalStateException("Already in queue " + this.workgroupJID);
        }
        JoinQueuePacket joinPacket = new JoinQueuePacket(this.workgroupJID, answerForm, userID);
        this.connection.createPacketCollectorAndSend((IQ)joinPacket).nextResultOrThrow();
        this.fireQueueJoinedEvent();
    }

    public void joinQueue(Map<String, Object> metadata, String userID) throws XMPPException, SmackException {
        if (this.inQueue) {
            throw new IllegalStateException("Already in queue " + this.workgroupJID);
        }
        Form form = new Form("submit");
        for (String name : metadata.keySet()) {
            String value = metadata.get(name).toString();
            FormField field = new FormField(name);
            field.setType("text-single");
            form.addField(field);
            form.setAnswer(name, value);
        }
        this.joinQueue(form, userID);
    }

    public void departQueue() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        if (!this.inQueue) {
            return;
        }
        DepartQueuePacket departPacket = new DepartQueuePacket(this.workgroupJID);
        this.connection.createPacketCollectorAndSend((IQ)departPacket).nextResultOrThrow();
        this.fireQueueDepartedEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addQueueListener(QueueListener queueListener) {
        List<QueueListener> list = this.queueListeners;
        synchronized (list) {
            if (!this.queueListeners.contains(queueListener)) {
                this.queueListeners.add(queueListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListener(QueueListener queueListener) {
        List<QueueListener> list = this.queueListeners;
        synchronized (list) {
            this.queueListeners.remove(queueListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInvitationListener(WorkgroupInvitationListener invitationListener) {
        List<WorkgroupInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            if (!this.invitationListeners.contains(invitationListener)) {
                this.invitationListeners.add(invitationListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeQueueListener(WorkgroupInvitationListener invitationListener) {
        List<WorkgroupInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            this.invitationListeners.remove(invitationListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInvitationEvent(WorkgroupInvitation invitation) {
        List<WorkgroupInvitationListener> list = this.invitationListeners;
        synchronized (list) {
            for (WorkgroupInvitationListener listener : this.invitationListeners) {
                listener.invitationReceived(invitation);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueJoinedEvent() {
        List<QueueListener> list = this.queueListeners;
        synchronized (list) {
            for (QueueListener listener : this.queueListeners) {
                listener.joinedQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueDepartedEvent() {
        List<QueueListener> list = this.queueListeners;
        synchronized (list) {
            for (QueueListener listener : this.queueListeners) {
                listener.departedQueue();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueuePositionEvent(int currentPosition) {
        List<QueueListener> list = this.queueListeners;
        synchronized (list) {
            for (QueueListener listener : this.queueListeners) {
                listener.queuePositionUpdated(currentPosition);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireQueueTimeEvent(int secondsRemaining) {
        List<QueueListener> list = this.queueListeners;
        synchronized (list) {
            for (QueueListener listener : this.queueListeners) {
                listener.queueWaitTimeUpdated(secondsRemaining);
            }
        }
    }

    private void handlePacket(Packet packet) {
        if (packet instanceof Message) {
            Message msg = (Message)packet;
            PacketExtension pe = msg.getExtension("depart-queue", "http://jabber.org/protocol/workgroup");
            PacketExtension queueStatus = msg.getExtension("queue-status", "http://jabber.org/protocol/workgroup");
            if (pe != null) {
                this.fireQueueDepartedEvent();
            } else if (queueStatus != null) {
                QueueUpdate queueUpdate = (QueueUpdate)queueStatus;
                if (queueUpdate.getPosition() != -1) {
                    this.fireQueuePositionEvent(queueUpdate.getPosition());
                }
                if (queueUpdate.getRemaingTime() != -1) {
                    this.fireQueueTimeEvent(queueUpdate.getRemaingTime());
                }
            } else {
                MUCUser.Invite invite;
                MUCUser mucUser = (MUCUser)msg.getExtension("x", "http://jabber.org/protocol/muc#user");
                MUCUser.Invite invite2 = invite = mucUser != null ? mucUser.getInvite() : null;
                if (invite != null && this.workgroupJID.equals(invite.getFrom())) {
                    String sessionID = null;
                    Map<String, List<String>> metaData = null;
                    pe = msg.getExtension("session", "http://jivesoftware.com/protocol/workgroup");
                    if (pe != null) {
                        sessionID = ((SessionID)pe).getSessionID();
                    }
                    if ((pe = msg.getExtension("metadata", "http://jivesoftware.com/protocol/workgroup")) != null) {
                        metaData = ((MetaData)pe).getMetaData();
                    }
                    WorkgroupInvitation inv = new WorkgroupInvitation(this.connection.getUser(), msg.getFrom(), this.workgroupJID, sessionID, msg.getBody(), msg.getFrom(), metaData);
                    this.fireInvitationEvent(inv);
                }
            }
        }
    }

    public ChatSetting getChatSetting(String key) throws XMPPException, SmackException {
        ChatSettings chatSettings = this.getChatSettings(key, -1);
        return chatSettings.getFirstEntry();
    }

    public ChatSettings getChatSettings(int type) throws XMPPException, SmackException {
        return this.getChatSettings(null, type);
    }

    public ChatSettings getChatSettings() throws XMPPException, SmackException {
        return this.getChatSettings(null, -1);
    }

    private ChatSettings getChatSettings(String key, int type) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        ChatSettings request = new ChatSettings();
        if (key != null) {
            request.setKey(key);
        }
        if (type != -1) {
            request.setType(type);
        }
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        ChatSettings response = (ChatSettings)this.connection.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        return response;
    }

    public boolean isEmailAvailable() throws SmackException {
        ServiceDiscoveryManager discoManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection);
        try {
            String workgroupService = StringUtils.parseServer((String)this.workgroupJID);
            DiscoverInfo infoResult = discoManager.discoverInfo(workgroupService);
            return infoResult.containsFeature("jive:email:provider");
        }
        catch (XMPPException e) {
            return false;
        }
    }

    public OfflineSettings getOfflineSettings() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        OfflineSettings request = new OfflineSettings();
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        OfflineSettings response = (OfflineSettings)this.connection.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        return response;
    }

    public SoundSettings getSoundSettings() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        SoundSettings request = new SoundSettings();
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        SoundSettings response = (SoundSettings)this.connection.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        return response;
    }

    public WorkgroupProperties getWorkgroupProperties() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        WorkgroupProperties request = new WorkgroupProperties();
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        WorkgroupProperties response = (WorkgroupProperties)this.connection.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        return response;
    }

    public WorkgroupProperties getWorkgroupProperties(String jid) throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        WorkgroupProperties request = new WorkgroupProperties();
        request.setJid(jid);
        request.setType(IQ.Type.GET);
        request.setTo(this.workgroupJID);
        WorkgroupProperties response = (WorkgroupProperties)this.connection.createPacketCollectorAndSend((IQ)request).nextResultOrThrow();
        return response;
    }

    public Form getWorkgroupForm() throws SmackException.NoResponseException, XMPPException.XMPPErrorException, SmackException.NotConnectedException {
        WorkgroupForm workgroupForm = new WorkgroupForm();
        workgroupForm.setType(IQ.Type.GET);
        workgroupForm.setTo(this.workgroupJID);
        WorkgroupForm response = (WorkgroupForm)this.connection.createPacketCollectorAndSend((IQ)workgroupForm).nextResultOrThrow();
        return Form.getFormFrom((Packet)response);
    }

    private class JoinQueuePacket
    extends IQ {
        private String userID = null;
        private DataForm form;

        public JoinQueuePacket(String workgroup2, Form answerForm, String userID) {
            this.userID = userID;
            this.setTo(workgroup2);
            this.setType(IQ.Type.SET);
            this.form = answerForm.getDataFormToSend();
            this.addExtension((PacketExtension)this.form);
        }

        public String getChildElementXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<join-queue xmlns=\"http://jabber.org/protocol/workgroup\">");
            buf.append("<queue-notifications/>");
            if (Workgroup.this.connection.isAnonymous()) {
                buf.append(new UserID(this.userID).toXML());
            }
            buf.append(this.form.toXML());
            buf.append("</join-queue>");
            return buf.toString();
        }
    }
}

