/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.ext.history;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.workgroup.util.MetaDataUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ChatMetadata
extends IQ {
    public static final String ELEMENT_NAME = "chat-metadata";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";
    private String sessionID;
    private Map<String, List<String>> map = new HashMap<String, List<String>>();

    public String getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public void setMetadata(Map<String, List<String>> metadata) {
        this.map = metadata;
    }

    public Map<String, List<String>> getMetadata() {
        return this.map;
    }

    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<").append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\">");
        buf.append("<sessionID>").append(this.getSessionID()).append("</sessionID>");
        buf.append("</").append(ELEMENT_NAME).append("> ");
        return buf.toString();
    }

    public static class Provider
    extends IQProvider<ChatMetadata> {
        public ChatMetadata parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
            ChatMetadata chatM = new ChatMetadata();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (parser.getName().equals("sessionID")) {
                        chatM.setSessionID(parser.nextText());
                        continue;
                    }
                    if (!parser.getName().equals("metadata")) continue;
                    Map<String, List<String>> map = MetaDataUtils.parseMetaData(parser);
                    chatM.setMetadata(map);
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals(ChatMetadata.ELEMENT_NAME)) continue;
                done = true;
            }
            return chatM;
        }
    }
}

