/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.workgroup.packet.SessionID;
import org.jivesoftware.smackx.workgroup.packet.UserID;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class OfferRevokeProvider
extends IQProvider<IQ> {
    public OfferRevokePacket parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
        String userJID;
        String userID = userJID = parser.getAttributeValue("", "jid");
        String reason = null;
        String sessionID = null;
        boolean done = false;
        while (!done) {
            int eventType = parser.next();
            if (eventType == 2 && parser.getName().equals("reason")) {
                reason = parser.nextText();
                continue;
            }
            if (eventType == 2 && parser.getName().equals("session")) {
                sessionID = parser.getAttributeValue("", "id");
                continue;
            }
            if (eventType == 2 && parser.getName().equals("user")) {
                userID = parser.getAttributeValue("", "id");
                continue;
            }
            if (eventType != 3 || !parser.getName().equals("offer-revoke")) continue;
            done = true;
        }
        return new OfferRevokePacket(userJID, userID, reason, sessionID);
    }

    public class OfferRevokePacket
    extends IQ {
        private String userJID;
        private String userID;
        private String sessionID;
        private String reason;

        public OfferRevokePacket(String userJID, String userID, String cause, String sessionID) {
            this.userJID = userJID;
            this.userID = userID;
            this.reason = cause;
            this.sessionID = sessionID;
        }

        public String getUserJID() {
            return this.userJID;
        }

        public String getUserID() {
            return this.userID;
        }

        public String getReason() {
            return this.reason;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public String getChildElementXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<offer-revoke xmlns=\"http://jabber.org/protocol/workgroup\" jid=\"").append(this.userID).append("\">");
            if (this.reason != null) {
                buf.append("<reason>").append(this.reason).append("</reason>");
            }
            if (this.sessionID != null) {
                buf.append(new SessionID(this.sessionID).toXML());
            }
            if (this.userID != null) {
                buf.append(new UserID(this.userID).toXML());
            }
            buf.append("</offer-revoke>");
            return buf.toString();
        }
    }
}

