/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smackx.workgroup.agent.InvitationRequest;
import org.jivesoftware.smackx.workgroup.agent.OfferContent;
import org.jivesoftware.smackx.workgroup.agent.TransferRequest;
import org.jivesoftware.smackx.workgroup.agent.UserRequest;
import org.jivesoftware.smackx.workgroup.packet.RoomInvitation;
import org.jivesoftware.smackx.workgroup.packet.RoomTransfer;
import org.jivesoftware.smackx.workgroup.util.MetaDataUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class OfferRequestProvider
extends IQProvider<IQ> {
    public OfferRequestPacket parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
        String userJID;
        int eventType = parser.getEventType();
        String sessionID = null;
        int timeout = -1;
        OfferContent content = null;
        boolean done = false;
        Map<String, List<String>> metaData = new HashMap<String, List<String>>();
        if (eventType != 2) {
            // empty if block
        }
        String userID = userJID = parser.getAttributeValue("", "jid");
        while (!done) {
            eventType = parser.next();
            if (eventType == 2) {
                String elemName = parser.getName();
                if ("timeout".equals(elemName)) {
                    timeout = Integer.parseInt(parser.nextText());
                    continue;
                }
                if ("metadata".equals(elemName)) {
                    metaData = MetaDataUtils.parseMetaData(parser);
                    continue;
                }
                if ("session".equals(elemName)) {
                    sessionID = parser.getAttributeValue("", "id");
                    continue;
                }
                if ("user".equals(elemName)) {
                    userID = parser.getAttributeValue("", "id");
                    continue;
                }
                if ("user-request".equals(elemName)) {
                    content = UserRequest.getInstance();
                    continue;
                }
                if ("invite".equals(elemName)) {
                    RoomInvitation invitation = (RoomInvitation)PacketParserUtils.parsePacketExtension((String)"invite", (String)"http://jabber.org/protocol/workgroup", (XmlPullParser)parser);
                    content = new InvitationRequest(invitation.getInviter(), invitation.getRoom(), invitation.getReason());
                    continue;
                }
                if (!"transfer".equals(elemName)) continue;
                RoomTransfer transfer = (RoomTransfer)PacketParserUtils.parsePacketExtension((String)"transfer", (String)"http://jabber.org/protocol/workgroup", (XmlPullParser)parser);
                content = new TransferRequest(transfer.getInviter(), transfer.getRoom(), transfer.getReason());
                continue;
            }
            if (eventType != 3 || !"offer".equals(parser.getName())) continue;
            done = true;
        }
        OfferRequestPacket offerRequest = new OfferRequestPacket(userJID, userID, timeout, metaData, sessionID, content);
        offerRequest.setType(IQ.Type.set);
        return offerRequest;
    }

    public static class OfferRequestPacket
    extends IQ {
        private int timeout;
        private String userID;
        private String userJID;
        private Map<String, List<String>> metaData;
        private String sessionID;
        private OfferContent content;

        public OfferRequestPacket(String userJID, String userID, int timeout, Map<String, List<String>> metaData, String sessionID, OfferContent content) {
            super("offer", "http://jabber.org/protocol/workgroup");
            this.userJID = userJID;
            this.userID = userID;
            this.timeout = timeout;
            this.metaData = metaData;
            this.sessionID = sessionID;
            this.content = content;
        }

        public String getUserID() {
            return this.userID;
        }

        public String getUserJID() {
            return this.userJID;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public OfferContent getContent() {
            return this.content;
        }

        public Map<String, List<String>> getMetaData() {
            return this.metaData;
        }

        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
            buf.append((CharSequence)" jid=\"").append((CharSequence)this.userJID).append((CharSequence)"\">");
            buf.append((CharSequence)"<timeout>").append((CharSequence)Integer.toString(this.timeout)).append((CharSequence)"</timeout>");
            if (this.sessionID != null) {
                buf.append('<').append((CharSequence)"session");
                buf.append((CharSequence)" session=\"");
                buf.append((CharSequence)this.getSessionID()).append((CharSequence)"\" xmlns=\"");
                buf.append((CharSequence)"http://jivesoftware.com/protocol/workgroup").append((CharSequence)"\"/>");
            }
            if (this.metaData != null) {
                buf.append((CharSequence)MetaDataUtils.serializeMetaData(this.metaData));
            }
            if (this.userID != null) {
                buf.append('<').append((CharSequence)"user");
                buf.append((CharSequence)" id=\"");
                buf.append((CharSequence)this.userID).append((CharSequence)"\" xmlns=\"");
                buf.append((CharSequence)"http://jivesoftware.com/protocol/workgroup").append((CharSequence)"\"/>");
            }
            return buf;
        }
    }
}

