/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smackx.workgroup.agent.AgentSession;
import org.jivesoftware.smackx.workgroup.agent.OfferContent;

public class Offer {
    private XMPPConnection connection;
    private AgentSession session;
    private String sessionID;
    private String userJID;
    private String userID;
    private String workgroupName;
    private Date expiresDate;
    private Map<String, List<String>> metaData;
    private OfferContent content;
    private boolean accepted = false;
    private boolean rejected = false;

    Offer(XMPPConnection conn, AgentSession agentSession, String userID, String userJID, String workgroupName, Date expiresDate, String sessionID, Map<String, List<String>> metaData, OfferContent content) {
        this.connection = conn;
        this.session = agentSession;
        this.userID = userID;
        this.userJID = userJID;
        this.workgroupName = workgroupName;
        this.expiresDate = expiresDate;
        this.sessionID = sessionID;
        this.metaData = metaData;
        this.content = content;
    }

    public void accept() throws SmackException.NotConnectedException {
        AcceptPacket acceptPacket = new AcceptPacket(this.session.getWorkgroupJID());
        this.connection.sendPacket((Packet)acceptPacket);
        this.accepted = true;
    }

    public void reject() throws SmackException.NotConnectedException {
        RejectPacket rejectPacket = new RejectPacket(this.session.getWorkgroupJID());
        this.connection.sendPacket((Packet)rejectPacket);
        this.rejected = true;
    }

    public String getUserID() {
        return this.userID;
    }

    public String getUserJID() {
        return this.userJID;
    }

    public String getWorkgroupName() {
        return this.workgroupName;
    }

    public Date getExpiresDate() {
        return this.expiresDate;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public Map<String, List<String>> getMetaData() {
        return this.metaData;
    }

    public OfferContent getContent() {
        return this.content;
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public boolean isRejected() {
        return this.rejected;
    }

    private class AcceptPacket
    extends IQ {
        AcceptPacket(String workgroup) {
            super("offer-accept", "http://jabber.org/protocol/workgroup");
            this.setTo(workgroup);
            this.setType(IQ.Type.set);
        }

        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            xml.attribute("id", Offer.this.getSessionID());
            xml.setEmptyElement();
            return xml;
        }
    }

    private class RejectPacket
    extends IQ {
        RejectPacket(String workgroup) {
            super("offer-reject", "http://jabber.org/protocol/workgroup");
            this.setTo(workgroup);
            this.setType(IQ.Type.set);
        }

        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            xml.attribute("id", Offer.this.getSessionID());
            xml.setEmptyElement();
            return xml;
        }
    }
}

