/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xevent;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.NotFilter;
import org.jivesoftware.smack.filter.PacketExtensionFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.xevent.MessageEventNotificationListener;
import org.jivesoftware.smackx.xevent.MessageEventRequestListener;
import org.jivesoftware.smackx.xevent.packet.MessageEvent;

public class MessageEventManager
extends Manager {
    private static final Logger LOGGER = Logger.getLogger(MessageEventManager.class.getName());
    private static final Map<XMPPConnection, MessageEventManager> INSTANCES = new WeakHashMap<XMPPConnection, MessageEventManager>();
    private static final PacketFilter PACKET_FILTER = new AndFilter(new PacketFilter[]{new PacketExtensionFilter((PacketExtension)new MessageEvent()), new NotFilter(MessageTypeFilter.ERROR)});
    private List<MessageEventNotificationListener> messageEventNotificationListeners = new CopyOnWriteArrayList<MessageEventNotificationListener>();
    private List<MessageEventRequestListener> messageEventRequestListeners = new CopyOnWriteArrayList<MessageEventRequestListener>();

    public static synchronized MessageEventManager getInstanceFor(XMPPConnection connection) {
        MessageEventManager messageEventManager = INSTANCES.get(connection);
        if (messageEventManager == null) {
            messageEventManager = new MessageEventManager(connection);
            INSTANCES.put(connection, messageEventManager);
        }
        return messageEventManager;
    }

    private MessageEventManager(XMPPConnection connection) {
        super(connection);
        connection.addAsyncPacketListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Message message = (Message)packet;
                MessageEvent messageEvent = (MessageEvent)message.getExtension("x", "jabber:x:event");
                if (messageEvent.isMessageEventRequest()) {
                    for (String eventType : messageEvent.getEventTypes()) {
                        MessageEventManager.this.fireMessageEventRequestListeners(message.getFrom(), message.getPacketID(), eventType.concat("NotificationRequested"));
                    }
                } else {
                    for (String eventType : messageEvent.getEventTypes()) {
                        MessageEventManager.this.fireMessageEventNotificationListeners(message.getFrom(), messageEvent.getPacketID(), eventType.concat("Notification"));
                    }
                }
            }
        }, PACKET_FILTER);
    }

    public static void addNotificationsRequests(Message message, boolean offline, boolean delivered, boolean displayed, boolean composing) {
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setOffline(offline);
        messageEvent.setDelivered(delivered);
        messageEvent.setDisplayed(displayed);
        messageEvent.setComposing(composing);
        message.addExtension((PacketExtension)messageEvent);
    }

    public void addMessageEventRequestListener(MessageEventRequestListener messageEventRequestListener) {
        this.messageEventRequestListeners.add(messageEventRequestListener);
    }

    public void removeMessageEventRequestListener(MessageEventRequestListener messageEventRequestListener) {
        this.messageEventRequestListeners.remove(messageEventRequestListener);
    }

    public void addMessageEventNotificationListener(MessageEventNotificationListener messageEventNotificationListener) {
        this.messageEventNotificationListeners.add(messageEventNotificationListener);
    }

    public void removeMessageEventNotificationListener(MessageEventNotificationListener messageEventNotificationListener) {
        this.messageEventNotificationListeners.remove(messageEventNotificationListener);
    }

    private void fireMessageEventRequestListeners(String from, String packetID, String methodName) {
        try {
            Method method = MessageEventRequestListener.class.getDeclaredMethod(methodName, String.class, String.class, MessageEventManager.class);
            for (MessageEventRequestListener listener : this.messageEventRequestListeners) {
                method.invoke((Object)listener, new Object[]{from, packetID, this});
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while invoking MessageEventRequestListener", e);
        }
    }

    private void fireMessageEventNotificationListeners(String from, String packetID, String methodName) {
        try {
            Method method = MessageEventNotificationListener.class.getDeclaredMethod(methodName, String.class, String.class);
            for (MessageEventNotificationListener listener : this.messageEventNotificationListeners) {
                method.invoke((Object)listener, from, packetID);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Error while invoking MessageEventNotificationListener", e);
        }
    }

    public void sendDeliveredNotification(String to, String packetID) throws SmackException.NotConnectedException {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setDelivered(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension((PacketExtension)messageEvent);
        this.connection().sendPacket((Packet)msg);
    }

    public void sendDisplayedNotification(String to, String packetID) throws SmackException.NotConnectedException {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setDisplayed(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension((PacketExtension)messageEvent);
        this.connection().sendPacket((Packet)msg);
    }

    public void sendComposingNotification(String to, String packetID) throws SmackException.NotConnectedException {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setComposing(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension((PacketExtension)messageEvent);
        this.connection().sendPacket((Packet)msg);
    }

    public void sendCancelledNotification(String to, String packetID) throws SmackException.NotConnectedException {
        Message msg = new Message(to);
        MessageEvent messageEvent = new MessageEvent();
        messageEvent.setCancelled(true);
        messageEvent.setPacketID(packetID);
        msg.addExtension((PacketExtension)messageEvent);
        this.connection().sendPacket((Packet)msg);
    }
}

