/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.workgroup.agent.AgentRosterListener;
import org.jivesoftware.smackx.workgroup.packet.AgentStatus;
import org.jivesoftware.smackx.workgroup.packet.AgentStatusRequest;
import org.jxmpp.util.XmppStringUtils;

public class AgentRoster {
    private static final Logger LOGGER = Logger.getLogger(AgentRoster.class.getName());
    private static final int EVENT_AGENT_ADDED = 0;
    private static final int EVENT_AGENT_REMOVED = 1;
    private static final int EVENT_PRESENCE_CHANGED = 2;
    private XMPPConnection connection;
    private String workgroupJID;
    private List<String> entries;
    private List<AgentRosterListener> listeners;
    private Map<String, Map<String, Presence>> presenceMap;
    boolean rosterInitialized = false;

    AgentRoster(XMPPConnection connection, String workgroupJID) throws SmackException.NotConnectedException {
        this.connection = connection;
        this.workgroupJID = workgroupJID;
        this.entries = new ArrayList<String>();
        this.listeners = new ArrayList<AgentRosterListener>();
        this.presenceMap = new HashMap<String, Map<String, Presence>>();
        PacketTypeFilter rosterFilter = new PacketTypeFilter(AgentStatusRequest.class);
        connection.addAsyncPacketListener((PacketListener)new AgentStatusListener(), (PacketFilter)rosterFilter);
        connection.addAsyncPacketListener((PacketListener)new PresencePacketListener(), (PacketFilter)new PacketTypeFilter(Presence.class));
        AgentStatusRequest request = new AgentStatusRequest();
        request.setTo(workgroupJID);
        connection.sendPacket((Stanza)request);
    }

    public void reload() throws SmackException.NotConnectedException {
        AgentStatusRequest request = new AgentStatusRequest();
        request.setTo(this.workgroupJID);
        this.connection.sendPacket((Stanza)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AgentRosterListener listener) {
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                for (String jid : this.getAgents()) {
                    if (!this.entries.contains(jid)) continue;
                    listener.agentAdded(jid);
                    Map<String, Presence> userPresences = this.presenceMap.get(jid);
                    if (userPresences == null) continue;
                    Iterator<Presence> presences = userPresences.values().iterator();
                    while (presences.hasNext()) {
                        listener.presenceChanged(presences.next());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AgentRosterListener listener) {
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public int getAgentCount() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAgents() {
        HashSet<String> agents = new HashSet<String>();
        List<String> list = this.entries;
        synchronized (list) {
            Iterator<String> i = this.entries.iterator();
            while (i.hasNext()) {
                agents.add(i.next());
            }
        }
        return Collections.unmodifiableSet(agents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String jid) {
        if (jid == null) {
            return false;
        }
        List<String> list = this.entries;
        synchronized (list) {
            for (String entry : this.entries) {
                if (!entry.toLowerCase(Locale.US).equals(jid.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public Presence getPresence(String user) {
        String key = this.getPresenceMapKey(user);
        Map<String, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            return presence;
        }
        Iterator<String> it = userPresences.keySet().iterator();
        Presence presence = null;
        while (it.hasNext()) {
            Presence p = userPresences.get(it.next());
            if (presence == null) {
                presence = p;
                continue;
            }
            if (p.getPriority() <= presence.getPriority()) continue;
            presence = p;
        }
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            return presence;
        }
        return presence;
    }

    private String getPresenceMapKey(String user) {
        String key = user;
        if (!this.contains(user)) {
            key = XmppStringUtils.parseBareJid((String)user).toLowerCase(Locale.US);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(int eventType, Object eventObject) {
        AgentRosterListener[] listeners = null;
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            listeners = new AgentRosterListener[this.listeners.size()];
            this.listeners.toArray(listeners);
        }
        block8: for (int i = 0; i < listeners.length; ++i) {
            switch (eventType) {
                case 0: {
                    listeners[i].agentAdded((String)eventObject);
                    continue block8;
                }
                case 1: {
                    listeners[i].agentRemoved((String)eventObject);
                    continue block8;
                }
                case 2: {
                    listeners[i].presenceChanged((Presence)eventObject);
                }
            }
        }
    }

    private class AgentStatusListener
    implements PacketListener {
        private AgentStatusListener() {
        }

        public void processPacket(Stanza packet) {
            if (packet instanceof AgentStatusRequest) {
                AgentStatusRequest statusRequest = (AgentStatusRequest)packet;
                for (AgentStatusRequest.Item item : statusRequest.getAgents()) {
                    String agentJID = item.getJID();
                    if ("remove".equals(item.getType())) {
                        String key = XmppStringUtils.parseLocalpart((String)(XmppStringUtils.parseLocalpart((String)agentJID) + "@" + XmppStringUtils.parseDomain((String)agentJID)));
                        AgentRoster.this.presenceMap.remove(key);
                        AgentRoster.this.fireEvent(1, agentJID);
                        continue;
                    }
                    AgentRoster.this.entries.add(agentJID);
                    AgentRoster.this.fireEvent(0, agentJID);
                }
                AgentRoster.this.rosterInitialized = true;
            }
        }
    }

    private class PresencePacketListener
    implements PacketListener {
        private PresencePacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Stanza packet) {
            Presence presence = (Presence)packet;
            String from = presence.getFrom();
            if (from == null) {
                LOGGER.warning("Presence with no FROM: " + presence.toXML());
                return;
            }
            String key = AgentRoster.this.getPresenceMapKey(from);
            if (presence.getType() == Presence.Type.available) {
                Map<String, Presence> userPresences;
                AgentStatus agentStatus = (AgentStatus)presence.getExtension("agent-status", "http://jabber.org/protocol/workgroup");
                if (agentStatus == null) {
                    return;
                }
                if (!AgentRoster.this.workgroupJID.equals(agentStatus.getWorkgroupJID())) {
                    return;
                }
                if (AgentRoster.this.presenceMap.get(key) == null) {
                    userPresences = new HashMap();
                    AgentRoster.this.presenceMap.put(key, userPresences);
                } else {
                    userPresences = (Map)AgentRoster.this.presenceMap.get(key);
                }
                Object object = userPresences;
                synchronized (object) {
                    userPresences.put(XmppStringUtils.parseResource((String)from), presence);
                }
                object = AgentRoster.this.entries;
                synchronized (object) {
                    for (String entry : AgentRoster.this.entries) {
                        if (!entry.toLowerCase(Locale.US).equals(XmppStringUtils.parseBareJid((String)key).toLowerCase())) continue;
                        AgentRoster.this.fireEvent(2, packet);
                    }
                }
            }
            if (presence.getType() == Presence.Type.unavailable) {
                if (AgentRoster.this.presenceMap.get(key) != null) {
                    Map userPresences;
                    Map userPresences2 = userPresences = (Map)AgentRoster.this.presenceMap.get(key);
                    synchronized (userPresences2) {
                        userPresences.remove(XmppStringUtils.parseResource((String)from));
                    }
                    if (userPresences.isEmpty()) {
                        AgentRoster.this.presenceMap.remove(key);
                    }
                }
                List list = AgentRoster.this.entries;
                synchronized (list) {
                    for (String entry : AgentRoster.this.entries) {
                        if (!entry.toLowerCase(Locale.US).equals(XmppStringUtils.parseBareJid((String)key).toLowerCase())) continue;
                        AgentRoster.this.fireEvent(2, packet);
                    }
                }
            }
        }
    }
}

