/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.io.IOException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.SimpleIQ;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class OfferConfirmation
extends SimpleIQ {
    private String userJID;
    private long sessionID;

    public OfferConfirmation() {
        super("offer-confirmation", "http://jabber.org/protocol/workgroup");
    }

    public String getUserJID() {
        return this.userJID;
    }

    public void setUserJID(String userJID) {
        this.userJID = userJID;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public void setSessionID(long sessionID) {
        this.sessionID = sessionID;
    }

    public void notifyService(XMPPConnection con, String workgroup, String createdRoomName) throws SmackException.NotConnectedException {
        NotifyServicePacket packet = new NotifyServicePacket(workgroup, createdRoomName);
        con.sendStanza((Stanza)packet);
    }

    private class NotifyServicePacket
    extends IQ {
        String roomName;

        NotifyServicePacket(String workgroup, String roomName) {
            super("offer-confirmation", "http://jabber.org/protocol/workgroup");
            this.setTo(workgroup);
            this.setType(IQ.Type.result);
            this.roomName = roomName;
        }

        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            xml.attribute("roomname", this.roomName);
            xml.setEmptyElement();
            return xml;
        }
    }

    public static class Provider
    extends IQProvider<OfferConfirmation> {
        public OfferConfirmation parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
            OfferConfirmation confirmation = new OfferConfirmation();
            boolean done = false;
            while (!done) {
                parser.next();
                String elementName = parser.getName();
                if (parser.getEventType() == 2 && "user-jid".equals(elementName)) {
                    try {
                        confirmation.setUserJID(parser.nextText());
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                if (parser.getEventType() == 2 && "session-id".equals(elementName)) {
                    try {
                        confirmation.setSessionID(Long.valueOf(parser.nextText()));
                    }
                    catch (NumberFormatException nfe) {}
                    continue;
                }
                if (parser.getEventType() != 3 || !"offer-confirmation".equals(elementName)) continue;
                done = true;
            }
            return confirmation;
        }
    }
}

