/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AgentWorkgroups
extends IQ {
    private String agentJID;
    private List<String> workgroups;

    private AgentWorkgroups() {
        super("workgroups", "http://jabber.org/protocol/workgroup");
    }

    public AgentWorkgroups(String agentJID) {
        this();
        this.agentJID = agentJID;
        this.workgroups = new ArrayList<String>();
    }

    public AgentWorkgroups(String agentJID, List<String> workgroups) {
        this();
        this.agentJID = agentJID;
        this.workgroups = workgroups;
    }

    public String getAgentJID() {
        return this.agentJID;
    }

    public List<String> getWorkgroups() {
        return Collections.unmodifiableList(this.workgroups);
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.attribute("jid", this.agentJID).rightAngleBracket();
        for (String workgroupJID : this.workgroups) {
            buf.append((CharSequence)("<workgroup jid=\"" + workgroupJID + "\"/>"));
        }
        return buf;
    }

    public static class Provider
    extends IQProvider<AgentWorkgroups> {
        public AgentWorkgroups parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
            String agentJID = parser.getAttributeValue("", "jid");
            ArrayList<String> workgroups = new ArrayList<String>();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (!parser.getName().equals("workgroup")) continue;
                    workgroups.add(parser.getAttributeValue("", "jid"));
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("workgroups")) continue;
                done = true;
            }
            return new AgentWorkgroups(agentJID, workgroups);
        }
    }
}

