/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.ext.macros;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.workgroup.ext.macros.Macro;
import org.jivesoftware.smackx.workgroup.ext.macros.MacroGroup;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class Macros
extends IQ {
    public static final String ELEMENT_NAME = "macros";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";
    private MacroGroup rootGroup;
    private boolean personal;
    private MacroGroup personalMacroGroup;

    public Macros() {
        super(ELEMENT_NAME, NAMESPACE);
    }

    public MacroGroup getRootGroup() {
        return this.rootGroup;
    }

    public void setRootGroup(MacroGroup rootGroup) {
        this.rootGroup = rootGroup;
    }

    public boolean isPersonal() {
        return this.personal;
    }

    public void setPersonal(boolean personal) {
        this.personal = personal;
    }

    public MacroGroup getPersonalMacroGroup() {
        return this.personalMacroGroup;
    }

    public void setPersonalMacroGroup(MacroGroup personalMacroGroup) {
        this.personalMacroGroup = personalMacroGroup;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.rightAngleBracket();
        if (this.isPersonal()) {
            buf.append((CharSequence)"<personal>true</personal>");
        }
        if (this.getPersonalMacroGroup() != null) {
            buf.append((CharSequence)"<personalMacro>");
            buf.append(StringUtils.escapeForXML((String)this.getPersonalMacroGroup().toXML()));
            buf.append((CharSequence)"</personalMacro>");
        }
        return buf;
    }

    public static class InternalProvider
    extends IQProvider<Macros> {
        public Macros parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
            Macros macroGroup = new Macros();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (!parser.getName().equals("model")) continue;
                    String macros = parser.nextText();
                    MacroGroup group = this.parseMacroGroups(macros);
                    macroGroup.setRootGroup(group);
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals(Macros.ELEMENT_NAME)) continue;
                done = true;
            }
            return macroGroup;
        }

        public Macro parseMacro(XmlPullParser parser) throws XmlPullParserException, IOException {
            Macro macro = new Macro();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (parser.getName().equals("title")) {
                        parser.next();
                        macro.setTitle(parser.getText());
                        continue;
                    }
                    if (parser.getName().equals("description")) {
                        macro.setDescription(parser.nextText());
                        continue;
                    }
                    if (parser.getName().equals("response")) {
                        macro.setResponse(parser.nextText());
                        continue;
                    }
                    if (!parser.getName().equals("type")) continue;
                    macro.setType(Integer.valueOf(parser.nextText()));
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("macro")) continue;
                done = true;
            }
            return macro;
        }

        public MacroGroup parseMacroGroup(XmlPullParser parser) throws XmlPullParserException, IOException {
            MacroGroup group = new MacroGroup();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2) {
                    if (parser.getName().equals("macrogroup")) {
                        group.addMacroGroup(this.parseMacroGroup(parser));
                    }
                    if (parser.getName().equals("title")) {
                        group.setTitle(parser.nextText());
                    }
                    if (!parser.getName().equals("macro")) continue;
                    group.addMacro(this.parseMacro(parser));
                    continue;
                }
                if (eventType != 3 || !parser.getName().equals("macrogroup")) continue;
                done = true;
            }
            return group;
        }

        public MacroGroup parseMacroGroups(String macros) throws XmlPullParserException, IOException {
            MacroGroup group = null;
            XmlPullParser parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setInput((Reader)new StringReader(macros));
            int eventType = parser.getEventType();
            while (eventType != 1) {
                eventType = parser.next();
                if (eventType != 2 || !parser.getName().equals("macrogroup")) continue;
                group = this.parseMacroGroup(parser);
            }
            return group;
        }
    }
}

