/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MetaDataUtils {
    public static Map<String, List<String>> parseMetaData(XmlPullParser parser) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        if (eventType == 2 && parser.getName().equals("metadata") && parser.getNamespace().equals("http://jivesoftware.com/protocol/workgroup")) {
            Hashtable<String, List<String>> metaData = new Hashtable<String, List<String>>();
            eventType = parser.nextTag();
            while (eventType != 3 || !parser.getName().equals("metadata")) {
                List<String> values;
                String name = parser.getAttributeValue(0);
                String value = parser.nextText();
                if (metaData.containsKey(name)) {
                    values = (List)metaData.get(name);
                    values.add(value);
                } else {
                    values = new ArrayList();
                    values.add(value);
                    metaData.put(name, values);
                }
                eventType = parser.nextTag();
            }
            return metaData;
        }
        return Collections.emptyMap();
    }

    public static String serializeMetaData(Map<String, List<String>> metaData) {
        StringBuilder buf = new StringBuilder();
        if (metaData != null && metaData.size() > 0) {
            buf.append("<metadata xmlns=\"http://jivesoftware.com/protocol/workgroup\">");
            for (String key : metaData.keySet()) {
                List<String> value = metaData.get(key);
                for (String v : value) {
                    buf.append("<value name=\"").append(key).append("\">");
                    buf.append(StringUtils.escapeForXML((String)v));
                    buf.append("</value>");
                }
            }
            buf.append("</metadata>");
        }
        return buf.toString();
    }
}

