/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smackx.workgroup.agent.AgentRosterListener;
import org.jivesoftware.smackx.workgroup.packet.AgentStatus;
import org.jivesoftware.smackx.workgroup.packet.AgentStatusRequest;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.util.XmppStringUtils;

public class AgentRoster {
    private static final Logger LOGGER = Logger.getLogger(AgentRoster.class.getName());
    private static final int EVENT_AGENT_ADDED = 0;
    private static final int EVENT_AGENT_REMOVED = 1;
    private static final int EVENT_PRESENCE_CHANGED = 2;
    private XMPPConnection connection;
    private Jid workgroupJID;
    private final List<String> entries = new ArrayList<String>();
    private final List<AgentRosterListener> listeners = new ArrayList<AgentRosterListener>();
    private final Map<Jid, Map<Resourcepart, Presence>> presenceMap = new HashMap<Jid, Map<Resourcepart, Presence>>();
    boolean rosterInitialized = false;

    AgentRoster(XMPPConnection connection, Jid workgroupJID) throws SmackException.NotConnectedException, InterruptedException {
        this.connection = connection;
        this.workgroupJID = workgroupJID;
        StanzaTypeFilter rosterFilter = new StanzaTypeFilter(AgentStatusRequest.class);
        connection.addAsyncStanzaListener((StanzaListener)new AgentStatusListener(), (StanzaFilter)rosterFilter);
        connection.addAsyncStanzaListener((StanzaListener)new PresencePacketListener(), (StanzaFilter)new StanzaTypeFilter(Presence.class));
        AgentStatusRequest request = new AgentStatusRequest();
        request.setTo(workgroupJID);
        connection.sendStanza((Stanza)request);
    }

    public void reload() throws SmackException.NotConnectedException, InterruptedException {
        AgentStatusRequest request = new AgentStatusRequest();
        request.setTo(this.workgroupJID);
        this.connection.sendStanza((Stanza)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AgentRosterListener listener) {
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                for (String jid : this.getAgents()) {
                    if (!this.entries.contains(jid)) continue;
                    listener.agentAdded(jid);
                    Map<Resourcepart, Presence> userPresences = this.presenceMap.get(jid);
                    if (userPresences == null) continue;
                    Iterator<Presence> presences = userPresences.values().iterator();
                    while (presences.hasNext()) {
                        listener.presenceChanged(presences.next());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AgentRosterListener listener) {
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public int getAgentCount() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAgents() {
        HashSet<String> agents = new HashSet<String>();
        List<String> list = this.entries;
        synchronized (list) {
            Iterator<String> i = this.entries.iterator();
            while (i.hasNext()) {
                agents.add(i.next());
            }
        }
        return Collections.unmodifiableSet(agents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Jid jid) {
        if (jid == null) {
            return false;
        }
        List<String> list = this.entries;
        synchronized (list) {
            for (String entry : this.entries) {
                if (!entry.equals(jid)) continue;
                return true;
            }
        }
        return false;
    }

    public Presence getPresence(Jid user) {
        Jid key = this.getPresenceMapKey(user);
        Map<Resourcepart, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            return presence;
        }
        Iterator<Resourcepart> it = userPresences.keySet().iterator();
        Presence presence = null;
        while (it.hasNext()) {
            Presence p = userPresences.get(it.next());
            if (presence == null) {
                presence = p;
                continue;
            }
            if (p.getPriority() <= presence.getPriority()) continue;
            presence = p;
        }
        if (presence == null) {
            presence = new Presence(Presence.Type.unavailable);
            presence.setFrom(user);
            return presence;
        }
        return presence;
    }

    private Jid getPresenceMapKey(Jid user) {
        Jid key = user;
        if (!this.contains(user)) {
            key = user.asEntityBareJidIfPossible();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(int eventType, Object eventObject) {
        AgentRosterListener[] listeners = null;
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            listeners = new AgentRosterListener[this.listeners.size()];
            this.listeners.toArray(listeners);
        }
        block8: for (int i = 0; i < listeners.length; ++i) {
            switch (eventType) {
                case 0: {
                    listeners[i].agentAdded((String)eventObject);
                    continue block8;
                }
                case 1: {
                    listeners[i].agentRemoved((String)eventObject);
                    continue block8;
                }
                case 2: {
                    listeners[i].presenceChanged((Presence)eventObject);
                }
            }
        }
    }

    private class AgentStatusListener
    implements StanzaListener {
        private AgentStatusListener() {
        }

        public void processPacket(Stanza packet) {
            if (packet instanceof AgentStatusRequest) {
                AgentStatusRequest statusRequest = (AgentStatusRequest)packet;
                for (AgentStatusRequest.Item item : statusRequest.getAgents()) {
                    String agentJID = item.getJID();
                    if ("remove".equals(item.getType())) {
                        String key = XmppStringUtils.parseLocalpart((String)(XmppStringUtils.parseLocalpart((String)agentJID) + "@" + XmppStringUtils.parseDomain((String)agentJID)));
                        AgentRoster.this.presenceMap.remove(key);
                        AgentRoster.this.fireEvent(1, agentJID);
                        continue;
                    }
                    AgentRoster.this.entries.add(agentJID);
                    AgentRoster.this.fireEvent(0, agentJID);
                }
                AgentRoster.this.rosterInitialized = true;
            }
        }
    }

    private class PresencePacketListener
    implements StanzaListener {
        private PresencePacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Stanza packet) {
            Presence presence = (Presence)packet;
            EntityFullJid from = presence.getFrom().asEntityFullJidIfPossible();
            if (from == null) {
                LOGGER.warning("Presence with non full JID from: " + presence.toXML());
                return;
            }
            Jid key = AgentRoster.this.getPresenceMapKey((Jid)from);
            if (presence.getType() == Presence.Type.available) {
                Map<Resourcepart, Presence> userPresences;
                AgentStatus agentStatus = (AgentStatus)presence.getExtension("agent-status", "http://jabber.org/protocol/workgroup");
                if (agentStatus == null) {
                    return;
                }
                if (!AgentRoster.this.workgroupJID.equals(agentStatus.getWorkgroupJID())) {
                    return;
                }
                if (AgentRoster.this.presenceMap.get(key) == null) {
                    userPresences = new HashMap();
                    AgentRoster.this.presenceMap.put(key, userPresences);
                } else {
                    userPresences = (Map)AgentRoster.this.presenceMap.get(key);
                }
                Object object = userPresences;
                synchronized (object) {
                    userPresences.put(from.getResourcepart(), presence);
                }
                object = AgentRoster.this.entries;
                synchronized (object) {
                    for (String entry : AgentRoster.this.entries) {
                        if (!entry.equals(key.asEntityBareJidIfPossible())) continue;
                        AgentRoster.this.fireEvent(2, packet);
                    }
                }
            }
            if (presence.getType() == Presence.Type.unavailable) {
                if (AgentRoster.this.presenceMap.get(key) != null) {
                    Map userPresences;
                    Map userPresences2 = userPresences = (Map)AgentRoster.this.presenceMap.get(key);
                    synchronized (userPresences2) {
                        userPresences.remove(from.getResourcepart());
                    }
                    if (userPresences.isEmpty()) {
                        AgentRoster.this.presenceMap.remove(key);
                    }
                }
                List list = AgentRoster.this.entries;
                synchronized (list) {
                    for (String entry : AgentRoster.this.entries) {
                        if (!entry.equals(key.asEntityBareJidIfPossible())) continue;
                        AgentRoster.this.fireEvent(2, packet);
                    }
                }
            }
        }
    }
}

