/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xroster;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterEntry;
import org.jivesoftware.smack.roster.RosterGroup;
import org.jivesoftware.smackx.xroster.RemoteRosterEntry;
import org.jivesoftware.smackx.xroster.RosterExchangeListener;
import org.jivesoftware.smackx.xroster.packet.RosterExchange;
import org.jxmpp.jid.Jid;

public class RosterExchangeManager {
    public static final String NAMESPACE = "jabber:x:roster";
    public static final String ELEMENT = "x";
    private static final Map<XMPPConnection, RosterExchangeManager> INSTANCES = new WeakHashMap<XMPPConnection, RosterExchangeManager>();
    private static final StanzaFilter PACKET_FILTER = new StanzaExtensionFilter("x", "jabber:x:roster");
    private final Set<RosterExchangeListener> rosterExchangeListeners = Collections.synchronizedSet(new HashSet());
    private final WeakReference<XMPPConnection> weakRefConnection;
    private final StanzaListener packetListener;

    public static synchronized RosterExchangeManager getInstanceFor(XMPPConnection connection) {
        RosterExchangeManager rosterExchangeManager = INSTANCES.get(connection);
        if (rosterExchangeManager == null) {
            rosterExchangeManager = new RosterExchangeManager(connection);
            INSTANCES.put(connection, rosterExchangeManager);
        }
        return rosterExchangeManager;
    }

    public RosterExchangeManager(XMPPConnection connection) {
        this.weakRefConnection = new WeakReference<XMPPConnection>(connection);
        this.packetListener = new StanzaListener(){

            public void processPacket(Stanza packet) {
                Message message = (Message)packet;
                RosterExchange rosterExchange = (RosterExchange)message.getExtension(RosterExchangeManager.ELEMENT, RosterExchangeManager.NAMESPACE);
                RosterExchangeManager.this.fireRosterExchangeListeners(message.getFrom(), rosterExchange.getRosterEntries());
            }
        };
        connection.addAsyncStanzaListener(this.packetListener, PACKET_FILTER);
    }

    public void addRosterListener(RosterExchangeListener rosterExchangeListener) {
        this.rosterExchangeListeners.add(rosterExchangeListener);
    }

    public void removeRosterListener(RosterExchangeListener rosterExchangeListener) {
        this.rosterExchangeListeners.remove(rosterExchangeListener);
    }

    public void send(Roster roster, Jid targetUserID) throws SmackException.NotConnectedException, InterruptedException {
        Message msg = new Message(targetUserID);
        RosterExchange rosterExchange = new RosterExchange(roster);
        msg.addExtension((ExtensionElement)rosterExchange);
        XMPPConnection connection = (XMPPConnection)this.weakRefConnection.get();
        connection.sendStanza((Stanza)msg);
    }

    public void send(RosterEntry rosterEntry, Jid targetUserID) throws SmackException.NotConnectedException, InterruptedException {
        Message msg = new Message(targetUserID);
        RosterExchange rosterExchange = new RosterExchange();
        rosterExchange.addRosterEntry(rosterEntry);
        msg.addExtension((ExtensionElement)rosterExchange);
        XMPPConnection connection = (XMPPConnection)this.weakRefConnection.get();
        connection.sendStanza((Stanza)msg);
    }

    public void send(RosterGroup rosterGroup, Jid targetUserID) throws SmackException.NotConnectedException, InterruptedException {
        Message msg = new Message(targetUserID);
        RosterExchange rosterExchange = new RosterExchange();
        for (RosterEntry entry : rosterGroup.getEntries()) {
            rosterExchange.addRosterEntry(entry);
        }
        msg.addExtension((ExtensionElement)rosterExchange);
        XMPPConnection connection = (XMPPConnection)this.weakRefConnection.get();
        connection.sendStanza((Stanza)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRosterExchangeListeners(Jid from, Iterator<RemoteRosterEntry> remoteRosterEntries) {
        RosterExchangeListener[] listeners = null;
        Set<RosterExchangeListener> set = this.rosterExchangeListeners;
        synchronized (set) {
            listeners = new RosterExchangeListener[this.rosterExchangeListeners.size()];
            this.rosterExchangeListeners.toArray(listeners);
        }
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].entriesReceived(from, remoteRosterEntries);
        }
    }
}

