/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class QueueUpdate
implements ExtensionElement {
    public static final String ELEMENT_NAME = "queue-status";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private int position;
    private int remainingTime;

    public QueueUpdate(int position, int remainingTime) {
        this.position = position;
        this.remainingTime = remainingTime;
    }

    public int getPosition() {
        return this.position;
    }

    public int getRemaingTime() {
        return this.remainingTime;
    }

    public String toXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<queue-status xmlns=\"http://jabber.org/protocol/workgroup\">");
        if (this.position != -1) {
            buf.append("<position>").append(this.position).append("</position>");
        }
        if (this.remainingTime != -1) {
            buf.append("<time>").append(this.remainingTime).append("</time>");
        }
        buf.append("</queue-status>");
        return buf.toString();
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public static class Provider
    extends ExtensionElementProvider<QueueUpdate> {
        public QueueUpdate parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
            boolean done = false;
            int position = -1;
            int timeRemaining = -1;
            while (!done) {
                parser.next();
                String elementName = parser.getName();
                if (parser.getEventType() == 2 && "position".equals(elementName)) {
                    try {
                        position = Integer.parseInt(parser.nextText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (parser.getEventType() == 2 && "time".equals(elementName)) {
                    try {
                        timeRemaining = Integer.parseInt(parser.nextText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (parser.getEventType() != 3 || !QueueUpdate.ELEMENT_NAME.equals(elementName)) continue;
                done = true;
            }
            return new QueueUpdate(position, timeRemaining);
        }
    }
}

