/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.settings;

import java.io.IOException;
import org.jivesoftware.smack.packet.SimpleIQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class SearchSettings
extends SimpleIQ {
    private String forumsLocation;
    private String kbLocation;
    public static final String ELEMENT_NAME = "search-settings";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";

    public boolean isSearchEnabled() {
        return StringUtils.isNotEmpty((CharSequence)this.getForumsLocation()) && StringUtils.isNotEmpty((CharSequence)this.getKbLocation());
    }

    public String getForumsLocation() {
        return this.forumsLocation;
    }

    public void setForumsLocation(String forumsLocation) {
        this.forumsLocation = forumsLocation;
    }

    public String getKbLocation() {
        return this.kbLocation;
    }

    public void setKbLocation(String kbLocation) {
        this.kbLocation = kbLocation;
    }

    public boolean hasKB() {
        return StringUtils.isNotEmpty((CharSequence)this.getKbLocation());
    }

    public boolean hasForums() {
        return StringUtils.isNotEmpty((CharSequence)this.getForumsLocation());
    }

    public SearchSettings() {
        super(ELEMENT_NAME, NAMESPACE);
    }

    public static class InternalProvider
    extends IQProvider<SearchSettings> {
        public SearchSettings parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
            SearchSettings settings = new SearchSettings();
            boolean done = false;
            String kb = null;
            String forums = null;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2 && "forums".equals(parser.getName())) {
                    forums = parser.nextText();
                    continue;
                }
                if (eventType == 2 && "kb".equals(parser.getName())) {
                    kb = parser.nextText();
                    continue;
                }
                if (eventType != 3 || !SearchSettings.ELEMENT_NAME.equals(parser.getName())) continue;
                done = true;
            }
            settings.setForumsLocation(forums);
            settings.setKbLocation(kb);
            return settings;
        }
    }
}

