/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ListenerEventDispatcher
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ListenerEventDispatcher.class.getName());
    protected transient ArrayList<TripletContainer> triplets = new ArrayList();
    protected transient boolean hasFinishedDispatching = false;
    protected transient boolean isRunning = false;

    public void addListenerTriplet(Object listenerInstance, Method listenerMethod, Object[] methodArguments) {
        if (!this.isRunning) {
            this.triplets.add(new TripletContainer(listenerInstance, listenerMethod, methodArguments));
        }
    }

    public boolean hasFinished() {
        return this.hasFinishedDispatching;
    }

    @Override
    public void run() {
        ListIterator<TripletContainer> li = null;
        this.isRunning = true;
        li = this.triplets.listIterator();
        while (li.hasNext()) {
            TripletContainer tc = li.next();
            try {
                tc.getListenerMethod().invoke(tc.getListenerInstance(), tc.getMethodArguments());
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception dispatching an event", e);
            }
        }
        this.hasFinishedDispatching = true;
    }

    protected static class TripletContainer {
        protected Object listenerInstance;
        protected Method listenerMethod;
        protected Object[] methodArguments;

        protected TripletContainer(Object inst, Method meth, Object[] args) {
            this.listenerInstance = inst;
            this.listenerMethod = meth;
            this.methodArguments = args;
        }

        protected Object getListenerInstance() {
            return this.listenerInstance;
        }

        protected Method getListenerMethod() {
            return this.listenerMethod;
        }

        protected Object[] getMethodArguments() {
            return this.methodArguments;
        }
    }
}

