/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class AgentStatusRequest
extends IQ {
    public static final String ELEMENT_NAME = "agent-status-request";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private final Set<Item> agents = new HashSet<Item>();

    public AgentStatusRequest() {
        super(ELEMENT_NAME, NAMESPACE);
    }

    public int getAgentCount() {
        return this.agents.size();
    }

    public Set<Item> getAgents() {
        return Collections.unmodifiableSet(this.agents);
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.rightAngleBracket();
        Set<Item> set = this.agents;
        synchronized (set) {
            for (Item item : this.agents) {
                buf.append((CharSequence)"<agent jid=\"").append((CharSequence)item.getJID()).append((CharSequence)"\">");
                if (item.getName() != null) {
                    buf.append((CharSequence)"<name xmlns=\"http://jivesoftware.com/protocol/workgroup\">");
                    buf.append((CharSequence)item.getName());
                    buf.append((CharSequence)"</name>");
                }
                buf.append((CharSequence)"</agent>");
            }
        }
        return buf;
    }

    public static class Provider
    extends IQProvider<AgentStatusRequest> {
        public AgentStatusRequest parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
            AgentStatusRequest statusRequest = new AgentStatusRequest();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2 && "agent".equals(parser.getName())) {
                    statusRequest.agents.add(this.parseAgent(parser));
                    continue;
                }
                if (eventType != 3 || !AgentStatusRequest.ELEMENT_NAME.equals(parser.getName())) continue;
                done = true;
            }
            return statusRequest;
        }

        private Item parseAgent(XmlPullParser parser) throws XmlPullParserException, IOException {
            boolean done = false;
            String jid = parser.getAttributeValue("", "jid");
            String type = parser.getAttributeValue("", "type");
            String name = null;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2 && "name".equals(parser.getName())) {
                    name = parser.nextText();
                    continue;
                }
                if (eventType != 3 || !"agent".equals(parser.getName())) continue;
                done = true;
            }
            return new Item(jid, type, name);
        }
    }

    public static class Item {
        private String jid;
        private String type;
        private String name;

        public Item(String jid, String type, String name) {
            this.jid = jid;
            this.type = type;
            this.name = name;
        }

        public String getJID() {
            return this.jid;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

