/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RoomTransfer
implements ExtensionElement {
    public static final String ELEMENT_NAME = "transfer";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private Type type;
    private String invitee;
    private String inviter;
    private String sessionID;
    private String room;
    private String reason;

    public RoomTransfer(Type type, String invitee, String sessionID, String reason) {
        this.type = type;
        this.invitee = invitee;
        this.sessionID = sessionID;
        this.reason = reason;
    }

    private RoomTransfer() {
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String getInviter() {
        return this.inviter;
    }

    public String getRoom() {
        return this.room;
    }

    public String getReason() {
        return this.reason;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public XmlStringBuilder toXML() {
        IQ.IQChildElementXmlStringBuilder xml = this.getIQChildElementBuilder(new IQ.IQChildElementXmlStringBuilder((ExtensionElement)this));
        xml.closeElement((NamedElement)this);
        return xml;
    }

    public IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.append((CharSequence)"\" type=\"").append((CharSequence)this.type.name()).append((CharSequence)"\">");
        buf.append((CharSequence)"<session xmlns=\"http://jivesoftware.com/protocol/workgroup\" id=\"").append((CharSequence)this.sessionID).append((CharSequence)"\"></session>");
        if (this.invitee != null) {
            buf.append((CharSequence)"<invitee>").append((CharSequence)this.invitee).append((CharSequence)"</invitee>");
        }
        if (this.inviter != null) {
            buf.append((CharSequence)"<inviter>").append((CharSequence)this.inviter).append((CharSequence)"</inviter>");
        }
        if (this.reason != null) {
            buf.append((CharSequence)"<reason>").append((CharSequence)this.reason).append((CharSequence)"</reason>");
        }
        return buf;
    }

    public static class Provider
    extends ExtensionElementProvider<RoomTransfer> {
        public RoomTransfer parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
            RoomTransfer invitation = new RoomTransfer();
            invitation.type = Type.valueOf(parser.getAttributeValue("", "type"));
            boolean done = false;
            while (!done) {
                parser.next();
                String elementName = parser.getName();
                if (parser.getEventType() == 2) {
                    if ("session".equals(elementName)) {
                        invitation.sessionID = parser.getAttributeValue("", "id");
                        continue;
                    }
                    if ("invitee".equals(elementName)) {
                        invitation.invitee = parser.nextText();
                        continue;
                    }
                    if ("inviter".equals(elementName)) {
                        invitation.inviter = parser.nextText();
                        continue;
                    }
                    if ("reason".equals(elementName)) {
                        invitation.reason = parser.nextText();
                        continue;
                    }
                    if (!"room".equals(elementName)) continue;
                    invitation.room = parser.nextText();
                    continue;
                }
                if (parser.getEventType() != 3 || !RoomTransfer.ELEMENT_NAME.equals(elementName)) continue;
                done = true;
            }
            return invitation;
        }
    }

    public static class RoomTransferIQ
    extends IQ {
        private final RoomTransfer roomTransfer;

        public RoomTransferIQ(RoomTransfer roomTransfer) {
            super(RoomTransfer.ELEMENT_NAME, RoomTransfer.NAMESPACE);
            this.roomTransfer = roomTransfer;
        }

        protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder xml) {
            return this.roomTransfer.getIQChildElementBuilder(xml);
        }
    }

    public static enum Type {
        user,
        queue,
        workgroup;

    }
}

