/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.IQ;
import org.jxmpp.jid.Jid;

public class Transcripts
extends IQ {
    private static final SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private Jid userID;
    private List<TranscriptSummary> summaries;

    public Transcripts(Jid userID) {
        this(userID, new ArrayList<TranscriptSummary>());
    }

    public Transcripts(Jid userID, List<TranscriptSummary> summaries) {
        super("transcripts", "http://jabber.org/protocol/workgroup");
        this.userID = userID;
        this.summaries = summaries;
    }

    public Jid getUserID() {
        return this.userID;
    }

    public List<TranscriptSummary> getSummaries() {
        return Collections.unmodifiableList(this.summaries);
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.append((CharSequence)" userID=\"").append((CharSequence)this.userID).append((CharSequence)"\">");
        for (TranscriptSummary transcriptSummary : this.summaries) {
            buf.append((CharSequence)transcriptSummary.toXML());
        }
        return buf;
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
    }

    public static class AgentDetail {
        private String agentJID;
        private Date joinTime;
        private Date leftTime;

        public AgentDetail(String agentJID, Date joinTime, Date leftTime) {
            this.agentJID = agentJID;
            this.joinTime = joinTime;
            this.leftTime = leftTime;
        }

        public String getAgentJID() {
            return this.agentJID;
        }

        public Date getJoinTime() {
            return this.joinTime;
        }

        public Date getLeftTime() {
            return this.leftTime;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<agent>");
            if (this.agentJID != null) {
                buf.append("<agentJID>").append(this.agentJID).append("</agentJID>");
            }
            if (this.joinTime != null) {
                buf.append("<joinTime>").append(UTC_FORMAT.format(this.joinTime)).append("</joinTime>");
            }
            if (this.leftTime != null) {
                buf.append("<leftTime>").append(UTC_FORMAT.format(this.leftTime)).append("</leftTime>");
            }
            buf.append("</agent>");
            return buf.toString();
        }
    }

    public static class TranscriptSummary {
        private String sessionID;
        private Date joinTime;
        private Date leftTime;
        private List<AgentDetail> agentDetails;

        public TranscriptSummary(String sessionID, Date joinTime, Date leftTime, List<AgentDetail> agentDetails) {
            this.sessionID = sessionID;
            this.joinTime = joinTime;
            this.leftTime = leftTime;
            this.agentDetails = agentDetails;
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public Date getJoinTime() {
            return this.joinTime;
        }

        public Date getLeftTime() {
            return this.leftTime;
        }

        public List<AgentDetail> getAgentDetails() {
            return this.agentDetails;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<transcript sessionID=\"").append(this.sessionID).append("\">");
            if (this.joinTime != null) {
                buf.append("<joinTime>").append(UTC_FORMAT.format(this.joinTime)).append("</joinTime>");
            }
            if (this.leftTime != null) {
                buf.append("<leftTime>").append(UTC_FORMAT.format(this.leftTime)).append("</leftTime>");
            }
            buf.append("<agents>");
            for (AgentDetail agentDetail : this.agentDetails) {
                buf.append(agentDetail.toXML());
            }
            buf.append("</agents></transcript>");
            return buf.toString();
        }
    }
}

