/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.settings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smackx.workgroup.settings.ChatSetting;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class ChatSettings
extends IQ {
    public static final int IMAGE_SETTINGS = 0;
    public static final int TEXT_SETTINGS = 1;
    public static final int BOT_SETTINGS = 2;
    private List<ChatSetting> settings = new ArrayList<ChatSetting>();
    private String key;
    private int type = -1;
    public static final String ELEMENT_NAME = "chat-settings";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";

    public ChatSettings() {
        super(ELEMENT_NAME, NAMESPACE);
    }

    public ChatSettings(String key) {
        this();
        this.setKey(key);
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void addSetting(ChatSetting setting) {
        this.settings.add(setting);
    }

    public Collection<ChatSetting> getSettings() {
        return this.settings;
    }

    public ChatSetting getChatSetting(String key) {
        Collection<ChatSetting> col = this.getSettings();
        if (col != null) {
            for (ChatSetting chatSetting : col) {
                if (!chatSetting.getKey().equals(key)) continue;
                return chatSetting;
            }
        }
        return null;
    }

    public ChatSetting getFirstEntry() {
        if (this.settings.size() > 0) {
            return this.settings.get(0);
        }
        return null;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        if (this.key != null) {
            buf.append((CharSequence)(" key=\"" + this.key + "\""));
        }
        if (this.type != -1) {
            buf.append((CharSequence)(" type=\"" + this.type + "\""));
        }
        buf.setEmptyElement();
        return buf;
    }

    public static class InternalProvider
    extends IQProvider<ChatSettings> {
        public ChatSettings parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException {
            if (parser.getEventType() != 2) {
                throw new IllegalStateException("Parser not in proper position, or bad XML.");
            }
            ChatSettings chatSettings = new ChatSettings();
            boolean done = false;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2 && "chat-setting".equals(parser.getName())) {
                    chatSettings.addSetting(InternalProvider.parseChatSetting(parser));
                    continue;
                }
                if (eventType != 3 || !ChatSettings.ELEMENT_NAME.equals(parser.getName())) continue;
                done = true;
            }
            return chatSettings;
        }

        private static ChatSetting parseChatSetting(XmlPullParser parser) throws XmlPullParserException, IOException {
            boolean done = false;
            String key = null;
            String value = null;
            int type = 0;
            while (!done) {
                int eventType = parser.next();
                if (eventType == 2 && "key".equals(parser.getName())) {
                    key = parser.nextText();
                    continue;
                }
                if (eventType == 2 && "value".equals(parser.getName())) {
                    value = parser.nextText();
                    continue;
                }
                if (eventType == 2 && "type".equals(parser.getName())) {
                    type = Integer.parseInt(parser.nextText());
                    continue;
                }
                if (eventType != 3 || !"chat-setting".equals(parser.getName())) continue;
                done = true;
            }
            return new ChatSetting(key, value, type);
        }
    }
}

