/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smackx.workgroup.agent.WorkgroupQueue;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class QueueOverview
implements ExtensionElement {
    public static String ELEMENT_NAME = "notify-queue";
    public static String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private static final String DATE_FORMAT = "yyyyMMdd'T'HH:mm:ss";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private int averageWaitTime = -1;
    private Date oldestEntry = null;
    private int userCount = -1;
    private WorkgroupQueue.Status status = null;

    QueueOverview() {
    }

    void setAverageWaitTime(int averageWaitTime) {
        this.averageWaitTime = averageWaitTime;
    }

    public int getAverageWaitTime() {
        return this.averageWaitTime;
    }

    void setOldestEntry(Date oldestEntry) {
        this.oldestEntry = oldestEntry;
    }

    public Date getOldestEntry() {
        return this.oldestEntry;
    }

    void setUserCount(int userCount) {
        this.userCount = userCount;
    }

    public int getUserCount() {
        return this.userCount;
    }

    public WorkgroupQueue.Status getStatus() {
        return this.status;
    }

    void setStatus(WorkgroupQueue.Status status) {
        this.status = status;
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public String toXML(String enclosingNamespace) {
        StringBuilder buf = new StringBuilder();
        buf.append('<').append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\">");
        if (this.userCount != -1) {
            buf.append("<count>").append(this.userCount).append("</count>");
        }
        if (this.oldestEntry != null) {
            buf.append("<oldest>").append(this.dateFormat.format(this.oldestEntry)).append("</oldest>");
        }
        if (this.averageWaitTime != -1) {
            buf.append("<time>").append(this.averageWaitTime).append("</time>");
        }
        if (this.status != null) {
            buf.append("<status>").append(this.status).append("</status>");
        }
        buf.append("</").append(ELEMENT_NAME).append('>');
        return buf.toString();
    }

    public static class Provider
    extends ExtensionElementProvider<QueueOverview> {
        public QueueOverview parse(XmlPullParser parser, int initialDepth) throws XmlPullParserException, IOException, SmackException {
            int eventType = parser.getEventType();
            QueueOverview queueOverview = new QueueOverview();
            SimpleDateFormat dateFormat = new SimpleDateFormat(QueueOverview.DATE_FORMAT);
            eventType = parser.next();
            while (eventType != 3 || !ELEMENT_NAME.equals(parser.getName())) {
                if ("count".equals(parser.getName())) {
                    queueOverview.setUserCount(Integer.parseInt(parser.nextText()));
                } else if ("time".equals(parser.getName())) {
                    queueOverview.setAverageWaitTime(Integer.parseInt(parser.nextText()));
                } else if ("oldest".equals(parser.getName())) {
                    try {
                        queueOverview.setOldestEntry(dateFormat.parse(parser.nextText()));
                    }
                    catch (ParseException e) {
                        throw new SmackException((Throwable)e);
                    }
                } else if ("status".equals(parser.getName())) {
                    queueOverview.setStatus(WorkgroupQueue.Status.fromString(parser.nextText()));
                }
                if ((eventType = parser.next()) == 3) continue;
            }
            if (eventType != 3) {
                // empty if block
            }
            return queueOverview;
        }
    }
}

