/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.ext.history;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.workgroup.ext.history.AgentChatSession;
import org.jxmpp.jid.EntityBareJid;

public class AgentChatHistory
extends IQ {
    public static final String ELEMENT_NAME = "chat-sessions";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";
    private EntityBareJid agentJID;
    private int maxSessions;
    private long startDate;
    private final List<AgentChatSession> agentChatSessions = new ArrayList<AgentChatSession>();

    public AgentChatHistory(EntityBareJid agentJID, int maxSessions, Date startDate) {
        this();
        this.agentJID = agentJID;
        this.maxSessions = maxSessions;
        this.startDate = startDate.getTime();
    }

    public AgentChatHistory(EntityBareJid agentJID, int maxSessions) {
        this();
        this.agentJID = agentJID;
        this.maxSessions = maxSessions;
        this.startDate = 0L;
    }

    public AgentChatHistory() {
        super(ELEMENT_NAME, NAMESPACE);
    }

    public void addChatSession(AgentChatSession chatSession) {
        this.agentChatSessions.add(chatSession);
    }

    public Collection<AgentChatSession> getAgentChatSessions() {
        return this.agentChatSessions;
    }

    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.append((CharSequence)(" agentJID=\"" + this.agentJID + "\""));
        buf.append((CharSequence)(" maxSessions=\"" + this.maxSessions + "\""));
        buf.append((CharSequence)(" startDate=\"" + this.startDate + "\""));
        buf.setEmptyElement();
        return buf;
    }

    public static class InternalProvider
    extends IQProvider<AgentChatHistory> {
        public AgentChatHistory parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
            if (parser.getEventType() != XmlPullParser.Event.START_ELEMENT) {
                throw new IllegalStateException("Parser not in proper position, or bad XML.");
            }
            AgentChatHistory agentChatHistory = new AgentChatHistory();
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && "chat-session".equals(parser.getName())) {
                    agentChatHistory.addChatSession(this.parseChatSetting(parser));
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !AgentChatHistory.ELEMENT_NAME.equals(parser.getName())) continue;
                done = true;
            }
            return agentChatHistory;
        }

        private AgentChatSession parseChatSetting(XmlPullParser parser) throws XmlPullParserException, IOException {
            boolean done = false;
            Date date = null;
            long duration = 0L;
            String visitorsName = null;
            String visitorsEmail = null;
            String sessionID = null;
            String question = null;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && "date".equals(parser.getName())) {
                    String dateStr = parser.nextText();
                    long l = Long.valueOf(dateStr);
                    date = new Date(l);
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "duration".equals(parser.getName())) {
                    duration = Long.valueOf(parser.nextText());
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "visitorsName".equals(parser.getName())) {
                    visitorsName = parser.nextText();
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "visitorsEmail".equals(parser.getName())) {
                    visitorsEmail = parser.nextText();
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "sessionID".equals(parser.getName())) {
                    sessionID = parser.nextText();
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "question".equals(parser.getName())) {
                    question = parser.nextText();
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !"chat-session".equals(parser.getName())) continue;
                done = true;
            }
            return new AgentChatSession(date, duration, visitorsName, visitorsEmail, sessionID, question);
        }
    }
}

