/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IQProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class OccupantsInfo
extends IQ {
    private static final SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    public static final String ELEMENT_NAME = "occupants-info";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";
    private final String roomID;
    private final Set<OccupantInfo> occupants;

    public OccupantsInfo(String roomID) {
        super(ELEMENT_NAME, NAMESPACE);
        this.roomID = roomID;
        this.occupants = new HashSet<OccupantInfo>();
    }

    public String getRoomID() {
        return this.roomID;
    }

    public int getOccupantsCount() {
        return this.occupants.size();
    }

    public Set<OccupantInfo> getOccupants() {
        return Collections.unmodifiableSet(this.occupants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.append((CharSequence)" roomID=\"").append((CharSequence)this.roomID).append((CharSequence)"\">");
        Set<OccupantInfo> set = this.occupants;
        synchronized (set) {
            for (OccupantInfo occupant : this.occupants) {
                buf.append((CharSequence)"<occupant>");
                buf.append((CharSequence)"<jid>");
                buf.append((CharSequence)occupant.getJID());
                buf.append((CharSequence)"</jid>");
                buf.append((CharSequence)"<name>");
                buf.append((CharSequence)occupant.getNickname());
                buf.append((CharSequence)"</name>");
                buf.append((CharSequence)"<joined>");
                SimpleDateFormat simpleDateFormat = UTC_FORMAT;
                synchronized (simpleDateFormat) {
                    buf.append((CharSequence)UTC_FORMAT.format(occupant.getJoined()));
                }
                buf.append((CharSequence)"</joined>");
                buf.append((CharSequence)"</occupant>");
            }
        }
        return buf;
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
    }

    public static class Provider
    extends IQProvider<OccupantsInfo> {
        public OccupantsInfo parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException.SmackTextParseException {
            OccupantsInfo occupantsInfo = new OccupantsInfo(parser.getAttributeValue("", "roomID"));
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && "occupant".equals(parser.getName())) {
                    occupantsInfo.occupants.add(Provider.parseOccupantInfo(parser));
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !OccupantsInfo.ELEMENT_NAME.equals(parser.getName())) continue;
                done = true;
            }
            return occupantsInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static OccupantInfo parseOccupantInfo(XmlPullParser parser) throws XmlPullParserException, IOException, SmackParsingException.SmackTextParseException {
            boolean done = false;
            String jid = null;
            String nickname = null;
            Date joined = null;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && "jid".equals(parser.getName())) {
                    jid = parser.nextText();
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "nickname".equals(parser.getName())) {
                    nickname = parser.nextText();
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "joined".equals(parser.getName())) {
                    SimpleDateFormat simpleDateFormat = UTC_FORMAT;
                    synchronized (simpleDateFormat) {
                        try {
                            joined = UTC_FORMAT.parse(parser.nextText());
                        }
                        catch (ParseException e) {
                            throw new SmackParsingException.SmackTextParseException(e);
                        }
                    }
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !"occupant".equals(parser.getName())) continue;
                done = true;
            }
            return new OccupantInfo(jid, nickname, joined);
        }
    }

    public static class OccupantInfo {
        private final String jid;
        private final String nickname;
        private final Date joined;

        public OccupantInfo(String jid, String nickname, Date joined) {
            this.jid = jid;
            this.nickname = nickname;
            this.joined = joined;
        }

        public String getJID() {
            return this.jid;
        }

        public String getNickname() {
            return this.nickname;
        }

        public Date getJoined() {
            return this.joined;
        }
    }
}

