/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.jid.EntityBareJid;

public class AgentStatusRequest
extends IQ {
    public static final String ELEMENT_NAME = "agent-status-request";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    private final Set<Item> agents = new HashSet<Item>();

    public AgentStatusRequest() {
        super(ELEMENT_NAME, NAMESPACE);
    }

    public int getAgentCount() {
        return this.agents.size();
    }

    public Set<Item> getAgents() {
        return Collections.unmodifiableSet(this.agents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.rightAngleBracket();
        Set<Item> set = this.agents;
        synchronized (set) {
            for (Item item : this.agents) {
                buf.append((CharSequence)"<agent jid=\"").append((CharSequence)item.getJID()).append((CharSequence)"\">");
                if (item.getName() != null) {
                    buf.append((CharSequence)"<name xmlns=\"http://jivesoftware.com/protocol/workgroup\">");
                    buf.append((CharSequence)item.getName());
                    buf.append((CharSequence)"</name>");
                }
                buf.append((CharSequence)"</agent>");
            }
        }
        return buf;
    }

    public static class Provider
    extends IqProvider<AgentStatusRequest> {
        public AgentStatusRequest parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
            AgentStatusRequest statusRequest = new AgentStatusRequest();
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && "agent".equals(parser.getName())) {
                    statusRequest.agents.add(Provider.parseAgent(parser));
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !AgentStatusRequest.ELEMENT_NAME.equals(parser.getName())) continue;
                done = true;
            }
            return statusRequest;
        }

        private static Item parseAgent(XmlPullParser parser) throws XmlPullParserException, IOException {
            boolean done = false;
            EntityBareJid jid = ParserUtils.getBareJidAttribute((XmlPullParser)parser);
            String type = parser.getAttributeValue("", "type");
            String name = null;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && "name".equals(parser.getName())) {
                    name = parser.nextText();
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !"agent".equals(parser.getName())) continue;
                done = true;
            }
            return new Item(jid, type, name);
        }
    }

    public static class Item {
        private final EntityBareJid jid;
        private final String type;
        private final String name;

        public Item(EntityBareJid jid, String type, String name) {
            this.jid = jid;
            this.type = type;
            this.name = name;
        }

        public EntityBareJid getJID() {
            return this.jid;
        }

        public String getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }
    }
}

