/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.settings;

import java.io.IOException;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.SimpleIQ;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class SearchSettings
extends SimpleIQ {
    private String forumsLocation;
    private String kbLocation;
    public static final String ELEMENT_NAME = "search-settings";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";

    public boolean isSearchEnabled() {
        return StringUtils.isNotEmpty((CharSequence)this.getForumsLocation()) && StringUtils.isNotEmpty((CharSequence)this.getKbLocation());
    }

    public String getForumsLocation() {
        return this.forumsLocation;
    }

    public void setForumsLocation(String forumsLocation) {
        this.forumsLocation = forumsLocation;
    }

    public String getKbLocation() {
        return this.kbLocation;
    }

    public void setKbLocation(String kbLocation) {
        this.kbLocation = kbLocation;
    }

    public boolean hasKB() {
        return StringUtils.isNotEmpty((CharSequence)this.getKbLocation());
    }

    public boolean hasForums() {
        return StringUtils.isNotEmpty((CharSequence)this.getForumsLocation());
    }

    public SearchSettings() {
        super(ELEMENT_NAME, NAMESPACE);
    }

    public static class InternalProvider
    extends IqProvider<SearchSettings> {
        public SearchSettings parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException {
            SearchSettings settings = new SearchSettings();
            boolean done = false;
            String kb = null;
            String forums = null;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && "forums".equals(parser.getName())) {
                    forums = parser.nextText();
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "kb".equals(parser.getName())) {
                    kb = parser.nextText();
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !SearchSettings.ELEMENT_NAME.equals(parser.getName())) continue;
                done = true;
            }
            settings.setForumsLocation(forums);
            settings.setKbLocation(kb);
            return settings;
        }
    }
}

