/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.util.ArrayList;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.workgroup.packet.Transcript;

public class TranscriptProvider
extends IqProvider<Transcript> {
    public Transcript parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment) throws XmlPullParserException, IOException, SmackParsingException {
        String sessionID = parser.getAttributeValue("", "sessionID");
        ArrayList<Stanza> packets = new ArrayList<Stanza>();
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                if (parser.getName().equals("message")) {
                    packets.add((Stanza)PacketParserUtils.parseMessage((XmlPullParser)parser));
                    continue;
                }
                if (!parser.getName().equals("presence")) continue;
                packets.add((Stanza)PacketParserUtils.parsePresence((XmlPullParser)parser));
                continue;
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("transcript")) continue;
            done = true;
        }
        return new Transcript(sessionID, packets);
    }
}

