/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.AbstractProvider;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jivesoftware.smackx.workgroup.QueueUser;
import org.jxmpp.JxmppContext;

public final class QueueDetails
implements ExtensionElement {
    private static final Logger LOGGER = Logger.getLogger(QueueDetails.class.getName());
    public static final String ELEMENT_NAME = "notify-queue-details";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    public static final QName QNAME = new QName("http://jabber.org/protocol/workgroup", "notify-queue-details");
    private static final String DATE_FORMAT = "yyyyMMdd'T'HH:mm:ss";
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private final Set<QueueUser> users = new HashSet<QueueUser>();

    public int getUserCount() {
        return this.users.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<QueueUser> getUsers() {
        Set<QueueUser> set = this.users;
        synchronized (set) {
            return this.users;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUser(QueueUser user) {
        Set<QueueUser> set = this.users;
        synchronized (set) {
            this.users.add(user);
        }
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXML(XmlEnvironment enclosingNamespace) {
        StringBuilder buf = new StringBuilder();
        buf.append('<').append(ELEMENT_NAME).append(" xmlns=\"").append(NAMESPACE).append("\">");
        Set<QueueUser> set = this.users;
        synchronized (set) {
            for (QueueUser user : this.users) {
                int position = user.getQueuePosition();
                int timeRemaining = user.getEstimatedRemainingTime();
                Date timestamp = user.getQueueJoinTimestamp();
                buf.append("<user jid=\"").append(user.getUserID()).append("\">");
                if (position != -1) {
                    buf.append("<position>").append(position).append("</position>");
                }
                if (timeRemaining != -1) {
                    buf.append("<time>").append(timeRemaining).append("</time>");
                }
                if (timestamp != null) {
                    buf.append("<join-time>");
                    buf.append(this.dateFormat.format(timestamp));
                    buf.append("</join-time>");
                }
                buf.append("</user>");
            }
        }
        buf.append("</").append(ELEMENT_NAME).append('>');
        return buf.toString();
    }

    public static class Provider
    extends ExtensionElementProvider<QueueDetails> {
        public QueueDetails parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, AbstractProvider.TextParseException, ParseException {
            SimpleDateFormat dateFormat = new SimpleDateFormat(QueueDetails.DATE_FORMAT);
            QueueDetails queueDetails = new QueueDetails();
            XmlPullParser.Event eventType = parser.getEventType();
            while (eventType != XmlPullParser.Event.END_ELEMENT && QueueDetails.ELEMENT_NAME.equals(parser.getName())) {
                eventType = parser.next();
                while (eventType == XmlPullParser.Event.START_ELEMENT && "user".equals(parser.getName())) {
                    int position = -1;
                    int time = -1;
                    Date joinTime = null;
                    String uid = parser.getAttributeValue("", "jid");
                    if (uid == null) {
                        // empty if block
                    }
                    eventType = parser.next();
                    while (eventType != XmlPullParser.Event.END_ELEMENT || !"user".equals(parser.getName())) {
                        if ("position".equals(parser.getName())) {
                            position = Integer.parseInt(parser.nextText());
                        } else if ("time".equals(parser.getName())) {
                            time = Integer.parseInt(parser.nextText());
                        } else if ("join-time".equals(parser.getName())) {
                            joinTime = dateFormat.parse(parser.nextText());
                        } else if (parser.getName().equals("waitTime")) {
                            Date wait = dateFormat.parse(parser.nextText());
                            LOGGER.fine(wait.toString());
                        }
                        if ((eventType = parser.next()) == XmlPullParser.Event.END_ELEMENT) continue;
                    }
                    queueDetails.addUser(new QueueUser(uid, position, time, joinTime));
                    eventType = parser.next();
                }
            }
            return queueDetails;
        }
    }
}

