/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.agent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.StanzaTypeFilter;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.PresenceBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smackx.workgroup.agent.AgentRosterListener;
import org.jivesoftware.smackx.workgroup.packet.AgentStatus;
import org.jivesoftware.smackx.workgroup.packet.AgentStatusRequest;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.EntityFullJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.jid.parts.Resourcepart;
import org.jxmpp.stringprep.XmppStringprepException;

public class AgentRoster {
    private static final Logger LOGGER = Logger.getLogger(AgentRoster.class.getName());
    private static final int EVENT_AGENT_ADDED = 0;
    private static final int EVENT_AGENT_REMOVED = 1;
    private static final int EVENT_PRESENCE_CHANGED = 2;
    private final XMPPConnection connection;
    private final EntityBareJid workgroupJID;
    private final List<EntityBareJid> entries = new ArrayList<EntityBareJid>();
    private final List<AgentRosterListener> listeners = new ArrayList<AgentRosterListener>();
    private final Map<Jid, Map<Resourcepart, Presence>> presenceMap = new HashMap<Jid, Map<Resourcepart, Presence>>();
    boolean rosterInitialized = false;

    AgentRoster(XMPPConnection connection, EntityBareJid workgroupJID) throws SmackException.NotConnectedException, InterruptedException {
        this.connection = connection;
        this.workgroupJID = workgroupJID;
        StanzaTypeFilter rosterFilter = new StanzaTypeFilter(AgentStatusRequest.class);
        connection.addAsyncStanzaListener((StanzaListener)new AgentStatusListener(), (StanzaFilter)rosterFilter);
        connection.addAsyncStanzaListener((StanzaListener)new PresencePacketListener(), (StanzaFilter)new StanzaTypeFilter(Presence.class));
        AgentStatusRequest request = new AgentStatusRequest();
        request.setTo((Jid)workgroupJID);
        connection.sendStanza((Stanza)request);
    }

    public void reload() throws SmackException.NotConnectedException, InterruptedException {
        AgentStatusRequest request = new AgentStatusRequest();
        request.setTo((Jid)this.workgroupJID);
        this.connection.sendStanza((Stanza)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AgentRosterListener listener) {
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(listener)) {
                this.listeners.add(listener);
                for (EntityBareJid jid : this.getAgents()) {
                    Jid j;
                    if (!this.entries.contains(jid)) continue;
                    listener.agentAdded(jid);
                    try {
                        j = JidCreate.from((CharSequence)jid);
                    }
                    catch (XmppStringprepException e) {
                        throw new IllegalStateException(e);
                    }
                    Map<Resourcepart, Presence> userPresences = this.presenceMap.get(j);
                    if (userPresences == null) continue;
                    Iterator<Presence> presences = userPresences.values().iterator();
                    while (presences.hasNext()) {
                        listener.presenceChanged(presences.next());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AgentRosterListener listener) {
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    public int getAgentCount() {
        return this.entries.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<EntityBareJid> getAgents() {
        HashSet<EntityBareJid> agents = new HashSet<EntityBareJid>();
        List<EntityBareJid> list = this.entries;
        synchronized (list) {
            Iterator<EntityBareJid> i = this.entries.iterator();
            while (i.hasNext()) {
                agents.add(i.next());
            }
        }
        return Collections.unmodifiableSet(agents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Jid jid) {
        if (jid == null) {
            return false;
        }
        List<EntityBareJid> list = this.entries;
        synchronized (list) {
            for (EntityBareJid entry : this.entries) {
                if (!entry.equals((CharSequence)jid)) continue;
                return true;
            }
        }
        return false;
    }

    public Presence getPresence(Jid user) {
        Jid key = this.getPresenceMapKey(user);
        Map<Resourcepart, Presence> userPresences = this.presenceMap.get(key);
        if (userPresences == null) {
            Presence presence = ((PresenceBuilder)StanzaBuilder.buildPresence().ofType(Presence.Type.unavailable).from(user)).build();
            return presence;
        }
        Iterator<Resourcepart> it = userPresences.keySet().iterator();
        Presence presence = null;
        while (it.hasNext()) {
            Presence p = userPresences.get(it.next());
            if (presence == null) {
                presence = p;
                continue;
            }
            if (p.getPriority() <= presence.getPriority()) continue;
            presence = p;
        }
        if (presence == null) {
            presence = AgentRoster.synthesizeUnvailablePresence(user);
            return presence;
        }
        return presence;
    }

    private Jid getPresenceMapKey(Jid user) {
        Jid key = user;
        if (!this.contains(user)) {
            key = user.asEntityBareJidIfPossible();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireEvent(int eventType, Object eventObject) {
        AgentRosterListener[] listeners;
        List<AgentRosterListener> list = this.listeners;
        synchronized (list) {
            listeners = new AgentRosterListener[this.listeners.size()];
            this.listeners.toArray(listeners);
        }
        block8: for (int i = 0; i < listeners.length; ++i) {
            switch (eventType) {
                case 0: {
                    listeners[i].agentAdded((EntityBareJid)eventObject);
                    continue block8;
                }
                case 1: {
                    listeners[i].agentRemoved((EntityBareJid)eventObject);
                    continue block8;
                }
                case 2: {
                    listeners[i].presenceChanged((Presence)eventObject);
                }
            }
        }
    }

    private static Presence synthesizeUnvailablePresence(Jid from) {
        return ((PresenceBuilder)StanzaBuilder.buildPresence().ofType(Presence.Type.unavailable).from(from)).build();
    }

    private final class AgentStatusListener
    implements StanzaListener {
        private AgentStatusListener() {
        }

        public void processStanza(Stanza packet) {
            if (packet instanceof AgentStatusRequest) {
                AgentStatusRequest statusRequest = (AgentStatusRequest)packet;
                for (AgentStatusRequest.Item item : statusRequest.getAgents()) {
                    EntityBareJid agentJID = item.getJID();
                    if ("remove".equals(item.getType())) {
                        AgentRoster.this.presenceMap.remove(agentJID.asBareJid());
                        AgentRoster.this.fireEvent(1, agentJID);
                        continue;
                    }
                    AgentRoster.this.entries.add(agentJID);
                    AgentRoster.this.fireEvent(0, agentJID);
                }
                AgentRoster.this.rosterInitialized = true;
            }
        }
    }

    private final class PresencePacketListener
    implements StanzaListener {
        private PresencePacketListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processStanza(Stanza packet) {
            Presence presence = (Presence)packet;
            EntityFullJid from = presence.getFrom().asEntityFullJidIfPossible();
            if (from == null) {
                LOGGER.warning("Presence with non full JID from: " + String.valueOf(presence.toXML()));
                return;
            }
            Jid key = AgentRoster.this.getPresenceMapKey((Jid)from);
            if (presence.getType() == Presence.Type.available) {
                Map<Object, Object> userPresences;
                AgentStatus agentStatus = (AgentStatus)presence.getExtensionElement("agent-status", "http://jabber.org/protocol/workgroup");
                if (agentStatus == null) {
                    return;
                }
                if (!AgentRoster.this.workgroupJID.equals((CharSequence)agentStatus.getWorkgroupJID())) {
                    return;
                }
                if (AgentRoster.this.presenceMap.get(key) == null) {
                    userPresences = new HashMap();
                    AgentRoster.this.presenceMap.put(key, userPresences);
                } else {
                    userPresences = AgentRoster.this.presenceMap.get(key);
                }
                Object object = userPresences;
                synchronized (object) {
                    userPresences.put(from.getResourcepart(), presence);
                }
                object = AgentRoster.this.entries;
                synchronized (object) {
                    for (EntityBareJid entry : AgentRoster.this.entries) {
                        if (!entry.equals((CharSequence)key.asEntityBareJidIfPossible())) continue;
                        AgentRoster.this.fireEvent(2, packet);
                    }
                }
            }
            if (presence.getType() == Presence.Type.unavailable) {
                if (AgentRoster.this.presenceMap.get(key) != null) {
                    Map<Resourcepart, Presence> userPresences = AgentRoster.this.presenceMap.get(key);
                    Map<Resourcepart, Presence> map = userPresences;
                    synchronized (map) {
                        userPresences.remove(from.getResourcepart());
                    }
                    if (userPresences.isEmpty()) {
                        AgentRoster.this.presenceMap.remove(key);
                    }
                }
                List<EntityBareJid> list = AgentRoster.this.entries;
                synchronized (list) {
                    for (EntityBareJid entry : AgentRoster.this.entries) {
                        if (!entry.equals((CharSequence)key.asEntityBareJidIfPossible())) continue;
                        AgentRoster.this.fireEvent(2, packet);
                    }
                }
            }
        }
    }
}

