/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.JxmppContext;

public class QueueUpdate
implements ExtensionElement {
    public static final String ELEMENT_NAME = "queue-status";
    public static final String NAMESPACE = "http://jabber.org/protocol/workgroup";
    public static final QName QNAME = new QName("http://jabber.org/protocol/workgroup", "queue-status");
    private final int position;
    private final int remainingTime;

    public QueueUpdate(int position, int remainingTime) {
        this.position = position;
        this.remainingTime = remainingTime;
    }

    public int getPosition() {
        return this.position;
    }

    public int getRemaingTime() {
        return this.remainingTime;
    }

    public String toXML(XmlEnvironment enclosingNamespace) {
        StringBuilder buf = new StringBuilder();
        buf.append("<queue-status xmlns=\"http://jabber.org/protocol/workgroup\">");
        if (this.position != -1) {
            buf.append("<position>").append(this.position).append("</position>");
        }
        if (this.remainingTime != -1) {
            buf.append("<time>").append(this.remainingTime).append("</time>");
        }
        buf.append("</queue-status>");
        return buf.toString();
    }

    public String getElementName() {
        return ELEMENT_NAME;
    }

    public String getNamespace() {
        return NAMESPACE;
    }

    public static class Provider
    extends ExtensionElementProvider<QueueUpdate> {
        public QueueUpdate parse(XmlPullParser parser, int initialDepth, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException {
            boolean done = false;
            int position = -1;
            int timeRemaining = -1;
            while (!done) {
                parser.next();
                if (parser.getEventType() == XmlPullParser.Event.START_ELEMENT && "position".equals(parser.getName())) {
                    position = Integer.parseInt(parser.nextText());
                    continue;
                }
                if (parser.getEventType() == XmlPullParser.Event.START_ELEMENT && "time".equals(parser.getName())) {
                    timeRemaining = Integer.parseInt(parser.nextText());
                    continue;
                }
                if (parser.getEventType() != XmlPullParser.Event.END_ELEMENT || !QueueUpdate.ELEMENT_NAME.equals(parser.getName())) continue;
                done = true;
            }
            return new QueueUpdate(position, timeRemaining);
        }
    }
}

