/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.signal;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.jivesoftware.smackx.omemo.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.element.OmemoBundleVAxolotlElement;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.internal.OmemoSession;
import org.jivesoftware.smackx.omemo.signal.SignalOmemoSession;
import org.jivesoftware.smackx.omemo.util.OmemoKeyUtil;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.state.PreKeyBundle;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;
import org.whispersystems.libsignal.util.KeyHelper;

public class SignalOmemoKeyUtil
extends OmemoKeyUtil<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> {
    public IdentityKeyPair generateOmemoIdentityKeyPair() {
        return KeyHelper.generateIdentityKeyPair();
    }

    public HashMap<Integer, PreKeyRecord> generateOmemoPreKeys(int currentPreKeyId, int count) {
        List preKeyRecords = KeyHelper.generatePreKeys((int)currentPreKeyId, (int)count);
        HashMap<Integer, PreKeyRecord> hashMap = new HashMap<Integer, PreKeyRecord>();
        for (PreKeyRecord p : preKeyRecords) {
            hashMap.put(p.getId(), p);
        }
        return hashMap;
    }

    public SignedPreKeyRecord generateOmemoSignedPreKey(IdentityKeyPair identityKeyPair, int currentPreKeyId) throws CorruptedOmemoKeyException {
        try {
            return KeyHelper.generateSignedPreKey((IdentityKeyPair)identityKeyPair, (int)currentPreKeyId);
        }
        catch (InvalidKeyException e) {
            throw new CorruptedOmemoKeyException(e.getMessage());
        }
    }

    public SignedPreKeyRecord signedPreKeyFromBytes(byte[] data) throws IOException {
        return new SignedPreKeyRecord(data);
    }

    public byte[] signedPreKeyToBytes(SignedPreKeyRecord signedPreKeyRecord) {
        return signedPreKeyRecord.serialize();
    }

    public OmemoSession<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> createOmemoSession(OmemoManager omemoManager, OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> omemoStore, OmemoDevice contact, IdentityKey identityKey) {
        return new SignalOmemoSession(omemoManager, omemoStore, contact, identityKey);
    }

    public OmemoSession<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> createOmemoSession(OmemoManager omemoManager, OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> omemoStore, OmemoDevice from) {
        return new SignalOmemoSession(omemoManager, omemoStore, from);
    }

    public SessionRecord rawSessionFromBytes(byte[] data) throws IOException {
        return new SessionRecord(data);
    }

    public byte[] rawSessionToBytes(SessionRecord session) {
        return session.serialize();
    }

    public IdentityKeyPair identityKeyPairFromBytes(byte[] data) throws CorruptedOmemoKeyException {
        try {
            return new IdentityKeyPair(data);
        }
        catch (InvalidKeyException e) {
            throw new CorruptedOmemoKeyException(e.getMessage());
        }
    }

    public IdentityKey identityKeyFromBytes(byte[] data) throws CorruptedOmemoKeyException {
        try {
            return new IdentityKey(data, 0);
        }
        catch (InvalidKeyException e) {
            throw new CorruptedOmemoKeyException(e.getMessage());
        }
    }

    public ECPublicKey ellipticCurvePublicKeyFromBytes(byte[] data) throws CorruptedOmemoKeyException {
        try {
            return Curve.decodePoint((byte[])data, (int)0);
        }
        catch (InvalidKeyException e) {
            throw new CorruptedOmemoKeyException(e.getMessage());
        }
    }

    public byte[] preKeyToBytes(PreKeyRecord preKeyRecord) {
        return preKeyRecord.serialize();
    }

    public PreKeyRecord preKeyFromBytes(byte[] bytes) throws IOException {
        return new PreKeyRecord(bytes);
    }

    public PreKeyBundle bundleFromOmemoBundle(OmemoBundleVAxolotlElement bundle, OmemoDevice contact, int preKeyId) throws CorruptedOmemoKeyException {
        return new PreKeyBundle(0, contact.getDeviceId(), preKeyId, (ECPublicKey)this.BUNDLE.preKeyPublic(bundle, preKeyId), this.BUNDLE.signedPreKeyId(bundle), (ECPublicKey)this.BUNDLE.signedPreKeyPublic(bundle), this.BUNDLE.signedPreKeySignature(bundle), (IdentityKey)this.BUNDLE.identityKey(bundle));
    }

    public byte[] signedPreKeySignatureFromKey(SignedPreKeyRecord signedPreKey) {
        return signedPreKey.getSignature();
    }

    public int signedPreKeyIdFromKey(SignedPreKeyRecord signedPreKey) {
        return signedPreKey.getId();
    }

    public byte[] identityKeyPairToBytes(IdentityKeyPair identityKeyPair) {
        return identityKeyPair.serialize();
    }

    public IdentityKey identityKeyFromPair(IdentityKeyPair identityKeyPair) {
        return identityKeyPair.getPublicKey();
    }

    public byte[] identityKeyForBundle(IdentityKey identityKey) {
        return identityKey.getPublicKey().serialize();
    }

    public byte[] identityKeyToBytes(IdentityKey identityKey) {
        return identityKey.serialize();
    }

    public byte[] preKeyPublicKeyForBundle(ECPublicKey preKey) {
        return preKey.serialize();
    }

    public byte[] preKeyForBundle(PreKeyRecord preKeyRecord) {
        return preKeyRecord.getKeyPair().getPublicKey().serialize();
    }

    public byte[] signedPreKeyPublicForBundle(SignedPreKeyRecord signedPreKey) {
        return signedPreKey.getKeyPair().getPublicKey().serialize();
    }

    public OmemoFingerprint getFingerprint(IdentityKey identityKey) {
        String fp = identityKey.getFingerprint();
        fp = fp.replace("(byte)0x", "").replace(",", "").replace(" ", "").substring(2);
        return new OmemoFingerprint(fp);
    }

    public SignalProtocolAddress omemoDeviceAsAddress(OmemoDevice contact) {
        return new SignalProtocolAddress(contact.getJid().asBareJid().toString(), contact.getDeviceId());
    }

    public OmemoDevice addressAsOmemoDevice(SignalProtocolAddress address) throws XmppStringprepException {
        return new OmemoDevice(JidCreate.bareFrom((String)address.getName()), address.getDeviceId());
    }
}

