/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.signal;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.logging.Level;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoService;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.signal.SignalFileBasedOmemoStore;
import org.jivesoftware.smackx.omemo.signal.SignalOmemoStoreConnector;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.SessionBuilder;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyBundle;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;
import org.whispersystems.libsignal.state.SignedPreKeyStore;

public final class SignalOmemoService
extends OmemoService<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> {
    private static SignalOmemoService INSTANCE;
    private static boolean LICENSE_ACKNOWLEDGED;

    public static void setup() throws InvalidKeyException, XMPPException.XMPPErrorException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, SmackException, InterruptedException, CorruptedOmemoKeyException {
        if (!LICENSE_ACKNOWLEDGED) {
            throw new IllegalStateException("smack-omemo-signal is licensed under the terms of the GPLv3. Please be aware that you can only use this library within the terms of the GPLv3. See for example https://www.gnu.org/licenses/quick-guide-gplv3 for more details. Please call SignalOmemoService.acknowledgeLicense() prior to the setup() method in order to prevent this exception.");
        }
        if (INSTANCE == null) {
            INSTANCE = new SignalOmemoService();
        }
        SignalOmemoService.setInstance((OmemoService)INSTANCE);
    }

    public OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> createDefaultOmemoStoreBackend() {
        return new SignalFileBasedOmemoStore();
    }

    private SignalOmemoService() throws SmackException, InterruptedException, XMPPException.XMPPErrorException, CorruptedOmemoKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException, UnsupportedEncodingException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, NoSuchProviderException, InvalidKeyException {
    }

    public static void acknowledgeLicense() {
        LICENSE_ACKNOWLEDGED = true;
    }

    protected void processBundle(OmemoManager omemoManager, PreKeyBundle preKeyBundle, OmemoDevice contact) throws CorruptedOmemoKeyException {
        SignalOmemoStoreConnector connector = new SignalOmemoStoreConnector(omemoManager, (OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher>)this.getOmemoStoreBackend());
        SessionBuilder builder = new SessionBuilder((SessionStore)connector, (PreKeyStore)connector, (SignedPreKeyStore)connector, (IdentityKeyStore)connector, (SignalProtocolAddress)this.getOmemoStoreBackend().keyUtil().omemoDeviceAsAddress(contact));
        try {
            builder.process(preKeyBundle);
            LOGGER.log(Level.INFO, "Session built with " + contact);
            this.getOmemoStoreBackend().getOmemoSessionOf(omemoManager, contact);
        }
        catch (org.whispersystems.libsignal.InvalidKeyException e) {
            throw new CorruptedOmemoKeyException(e.getMessage());
        }
        catch (UntrustedIdentityException e) {
            throw new AssertionError((Object)e);
        }
    }

    static {
        LICENSE_ACKNOWLEDGED = false;
    }
}

