/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.signal;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.NoRawSessionException;
import org.jivesoftware.smackx.omemo.internal.CiphertextTuple;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.internal.OmemoSession;
import org.jivesoftware.smackx.omemo.signal.SignalOmemoStoreConnector;
import org.whispersystems.libsignal.DuplicateMessageException;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.InvalidMessageException;
import org.whispersystems.libsignal.InvalidVersionException;
import org.whispersystems.libsignal.LegacyMessageException;
import org.whispersystems.libsignal.NoSessionException;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.UntrustedIdentityException;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.protocol.CiphertextMessage;
import org.whispersystems.libsignal.protocol.PreKeySignalMessage;
import org.whispersystems.libsignal.protocol.SignalMessage;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyBundle;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;
import org.whispersystems.libsignal.state.SignedPreKeyStore;

public class SignalOmemoSession
extends OmemoSession<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> {
    private static final Logger LOGGER = Logger.getLogger(SignalOmemoSession.class.getName());

    SignalOmemoSession(OmemoManager omemoManager, OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> omemoStore, OmemoDevice remoteContact, IdentityKey identityKey) {
        super(omemoManager, omemoStore, remoteContact, (Object)identityKey);
    }

    SignalOmemoSession(OmemoManager omemoManager, OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> omemoStore, OmemoDevice remoteContact) {
        super(omemoManager, omemoStore, remoteContact);
    }

    public SessionCipher createCipher(OmemoDevice contact) {
        SignalOmemoStoreConnector connector = new SignalOmemoStoreConnector(this.omemoManager, (OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher>)this.omemoStore);
        return new SessionCipher((SessionStore)connector, (PreKeyStore)connector, (SignedPreKeyStore)connector, (IdentityKeyStore)connector, (SignalProtocolAddress)this.omemoStore.keyUtil().omemoDeviceAsAddress(contact));
    }

    public CiphertextTuple encryptMessageKey(byte[] messageKey) {
        CiphertextMessage ciphertextMessage = ((SessionCipher)this.cipher).encrypt(messageKey);
        int type = ciphertextMessage.getType() == 3 ? 1 : 0;
        return new CiphertextTuple(ciphertextMessage.serialize(), type);
    }

    public byte[] decryptMessageKey(byte[] encryptedKey) throws NoRawSessionException {
        byte[] decryptedKey = null;
        try {
            try {
                PreKeySignalMessage message = new PreKeySignalMessage(encryptedKey);
                if (!message.getPreKeyId().isPresent()) {
                    LOGGER.log(Level.WARNING, "PreKeySignalMessage did not contain a PreKeyId");
                    return null;
                }
                LOGGER.log(Level.INFO, "PreKeySignalMessage received, new session ID: " + message.getSignedPreKeyId() + "/" + message.getPreKeyId().get());
                IdentityKey messageIdentityKey = message.getIdentityKey();
                if (this.identityKey != null && !((IdentityKey)this.identityKey).equals((Object)messageIdentityKey)) {
                    LOGGER.log(Level.INFO, "Had session with fingerprint " + this.getFingerprint() + ", received message with different fingerprint " + this.omemoStore.keyUtil().getFingerprint((Object)messageIdentityKey) + ". Silently drop the message.");
                } else {
                    this.identityKey = messageIdentityKey;
                    decryptedKey = ((SessionCipher)this.cipher).decrypt(message);
                    this.preKeyId = (Integer)message.getPreKeyId().get();
                }
            }
            catch (InvalidMessageException | InvalidVersionException e) {
                SignalMessage message = new SignalMessage(encryptedKey);
                decryptedKey = ((SessionCipher)this.cipher).decrypt(message);
            }
            catch (InvalidKeyIdException e) {
                throw new NoRawSessionException((Exception)((Object)e));
            }
            catch (InvalidKeyException | UntrustedIdentityException e) {
                LOGGER.log(Level.SEVERE, "Error decrypting message header, " + e.getClass().getName() + ": " + e.getMessage());
            }
        }
        catch (InvalidMessageException | NoSessionException e) {
            throw new NoRawSessionException((Exception)e);
        }
        catch (DuplicateMessageException | LegacyMessageException e) {
            LOGGER.log(Level.SEVERE, "Error decrypting message header, " + e.getClass().getName() + ": " + e.getMessage());
        }
        return decryptedKey;
    }
}

