/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.signal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyBundle;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;
import org.whispersystems.libsignal.state.SignedPreKeyStore;

public class SignalOmemoStoreConnector
implements IdentityKeyStore,
SessionStore,
PreKeyStore,
SignedPreKeyStore {
    private static final Logger LOGGER = Logger.getLogger(SignalOmemoStoreConnector.class.getName());
    private final OmemoManager omemoManager;
    private final OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> omemoStore;

    public SignalOmemoStoreConnector(OmemoManager omemoManager, OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> store) {
        this.omemoManager = omemoManager;
        this.omemoStore = store;
    }

    public IdentityKeyPair getIdentityKeyPair() {
        try {
            return (IdentityKeyPair)this.omemoStore.loadOmemoIdentityKeyPair(this.omemoManager);
        }
        catch (CorruptedOmemoKeyException e) {
            LOGGER.log(Level.SEVERE, "getIdentityKeyPair has failed: " + (Object)((Object)e), e);
            return null;
        }
    }

    public int getLocalRegistrationId() {
        return 0;
    }

    public void saveIdentity(SignalProtocolAddress signalProtocolAddress, IdentityKey identityKey) {
        try {
            this.omemoStore.storeOmemoIdentityKey(this.omemoManager, this.omemoStore.keyUtil().addressAsOmemoDevice((Object)signalProtocolAddress), (Object)identityKey);
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean isTrustedIdentity(SignalProtocolAddress signalProtocolAddress, IdentityKey identityKey) {
        return true;
    }

    public PreKeyRecord loadPreKey(int i) throws InvalidKeyIdException {
        PreKeyRecord pr = (PreKeyRecord)this.omemoStore.loadOmemoPreKey(this.omemoManager, i);
        if (pr == null) {
            throw new InvalidKeyIdException("No PreKey with Id " + i + " found!");
        }
        return pr;
    }

    public void storePreKey(int i, PreKeyRecord preKeyRecord) {
        this.omemoStore.storeOmemoPreKey(this.omemoManager, i, (Object)preKeyRecord);
    }

    public boolean containsPreKey(int i) {
        try {
            return this.loadPreKey(i) != null;
        }
        catch (InvalidKeyIdException e) {
            LOGGER.log(Level.WARNING, "containsPreKey has failed: " + e.getMessage());
            return false;
        }
    }

    public void removePreKey(int i) {
        this.omemoStore.removeOmemoPreKey(this.omemoManager, i);
    }

    public SessionRecord loadSession(SignalProtocolAddress signalProtocolAddress) {
        try {
            SessionRecord s = (SessionRecord)this.omemoStore.loadRawSession(this.omemoManager, this.omemoStore.keyUtil().addressAsOmemoDevice((Object)signalProtocolAddress));
            return s != null ? s : new SessionRecord();
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
    }

    public List<Integer> getSubDeviceSessions(String s) {
        HashMap contactsSessions;
        try {
            contactsSessions = this.omemoStore.loadAllRawSessionsOf(this.omemoManager, JidCreate.bareFrom((String)s));
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
        if (contactsSessions != null) {
            return new ArrayList<Integer>(contactsSessions.keySet());
        }
        return new ArrayList<Integer>();
    }

    public void storeSession(SignalProtocolAddress signalProtocolAddress, SessionRecord sessionRecord) {
        try {
            this.omemoStore.storeRawSession(this.omemoManager, this.omemoStore.keyUtil().addressAsOmemoDevice((Object)signalProtocolAddress), (Object)sessionRecord);
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
    }

    public boolean containsSession(SignalProtocolAddress signalProtocolAddress) {
        try {
            return this.omemoStore.containsRawSession(this.omemoManager, this.omemoStore.keyUtil().addressAsOmemoDevice((Object)signalProtocolAddress));
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void deleteSession(SignalProtocolAddress signalProtocolAddress) {
        try {
            this.omemoStore.removeRawSession(this.omemoManager, this.omemoStore.keyUtil().addressAsOmemoDevice((Object)signalProtocolAddress));
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void deleteAllSessions(String s) {
        try {
            this.omemoStore.removeAllRawSessionsOf(this.omemoManager, JidCreate.bareFrom((String)s));
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
    }

    public SignedPreKeyRecord loadSignedPreKey(int i) throws InvalidKeyIdException {
        SignedPreKeyRecord spkr = (SignedPreKeyRecord)this.omemoStore.loadOmemoSignedPreKey(this.omemoManager, i);
        if (spkr == null) {
            throw new InvalidKeyIdException("No SignedPreKey with Id " + i + " found!");
        }
        return spkr;
    }

    public List<SignedPreKeyRecord> loadSignedPreKeys() {
        HashMap signedPreKeyRecordHashMap = this.omemoStore.loadOmemoSignedPreKeys(this.omemoManager);
        ArrayList<SignedPreKeyRecord> signedPreKeyRecordList = new ArrayList<SignedPreKeyRecord>();
        signedPreKeyRecordList.addAll(signedPreKeyRecordHashMap.values());
        return signedPreKeyRecordList;
    }

    public void storeSignedPreKey(int i, SignedPreKeyRecord signedPreKeyRecord) {
        this.omemoStore.storeOmemoSignedPreKey(this.omemoManager, i, (Object)signedPreKeyRecord);
    }

    public boolean containsSignedPreKey(int i) {
        try {
            return this.loadSignedPreKey(i) != null;
        }
        catch (InvalidKeyIdException e) {
            LOGGER.log(Level.WARNING, "containsSignedPreKey has failed: " + e.getMessage());
            return false;
        }
    }

    public void removeSignedPreKey(int i) {
        this.omemoStore.removeOmemoSignedPreKey(this.omemoManager, i);
    }
}

