/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.signal;

import java.io.IOException;
import java.util.List;
import java.util.TreeMap;
import org.jivesoftware.smackx.omemo.element.OmemoBundleElement;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.trust.OmemoFingerprint;
import org.jivesoftware.smackx.omemo.util.OmemoKeyUtil;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyException;
import org.whispersystems.libsignal.ecc.Curve;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.state.PreKeyBundle;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;
import org.whispersystems.libsignal.util.KeyHelper;

public class SignalOmemoKeyUtil
extends OmemoKeyUtil<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, ECPublicKey, PreKeyBundle> {
    public IdentityKeyPair generateOmemoIdentityKeyPair() {
        return KeyHelper.generateIdentityKeyPair();
    }

    public TreeMap<Integer, PreKeyRecord> generateOmemoPreKeys(int currentPreKeyId, int count) {
        List preKeyRecords = KeyHelper.generatePreKeys((int)currentPreKeyId, (int)count);
        TreeMap<Integer, PreKeyRecord> map = new TreeMap<Integer, PreKeyRecord>();
        for (PreKeyRecord p : preKeyRecords) {
            map.put(p.getId(), p);
        }
        return map;
    }

    public SignedPreKeyRecord generateOmemoSignedPreKey(IdentityKeyPair identityKeyPair, int currentPreKeyId) throws CorruptedOmemoKeyException {
        try {
            return KeyHelper.generateSignedPreKey((IdentityKeyPair)identityKeyPair, (int)currentPreKeyId);
        }
        catch (InvalidKeyException e) {
            throw new CorruptedOmemoKeyException(e.getMessage());
        }
    }

    public SignedPreKeyRecord signedPreKeyFromBytes(byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        return new SignedPreKeyRecord(data);
    }

    public byte[] signedPreKeyToBytes(SignedPreKeyRecord signedPreKeyRecord) {
        return signedPreKeyRecord.serialize();
    }

    public SessionRecord rawSessionFromBytes(byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        return new SessionRecord(data);
    }

    public byte[] rawSessionToBytes(SessionRecord session) {
        return session.serialize();
    }

    public IdentityKeyPair identityKeyPairFromBytes(byte[] data) throws CorruptedOmemoKeyException {
        if (data == null) {
            return null;
        }
        try {
            return new IdentityKeyPair(data);
        }
        catch (InvalidKeyException e) {
            throw new CorruptedOmemoKeyException(e.getMessage());
        }
    }

    public IdentityKey identityKeyFromBytes(byte[] data) throws CorruptedOmemoKeyException {
        if (data == null) {
            return null;
        }
        try {
            return new IdentityKey(data, 0);
        }
        catch (InvalidKeyException e) {
            throw new CorruptedOmemoKeyException(e.getMessage());
        }
    }

    public ECPublicKey ellipticCurvePublicKeyFromBytes(byte[] data) throws CorruptedOmemoKeyException {
        if (data == null) {
            return null;
        }
        try {
            return Curve.decodePoint((byte[])data, (int)0);
        }
        catch (InvalidKeyException e) {
            throw new CorruptedOmemoKeyException(e.getMessage());
        }
    }

    public byte[] preKeyToBytes(PreKeyRecord preKeyRecord) {
        return preKeyRecord.serialize();
    }

    public PreKeyRecord preKeyFromBytes(byte[] bytes) throws IOException {
        if (bytes == null) {
            return null;
        }
        return new PreKeyRecord(bytes);
    }

    public PreKeyBundle bundleFromOmemoBundle(OmemoBundleElement bundle, OmemoDevice contact, int preKeyId) throws CorruptedOmemoKeyException {
        return new PreKeyBundle(0, contact.getDeviceId(), preKeyId, (ECPublicKey)this.BUNDLE.preKeyPublic(bundle, preKeyId), this.BUNDLE.signedPreKeyId(bundle), (ECPublicKey)this.BUNDLE.signedPreKeyPublic(bundle), this.BUNDLE.signedPreKeySignature(bundle), (IdentityKey)this.BUNDLE.identityKey(bundle));
    }

    public byte[] signedPreKeySignatureFromKey(SignedPreKeyRecord signedPreKey) {
        return signedPreKey.getSignature();
    }

    public int signedPreKeyIdFromKey(SignedPreKeyRecord signedPreKey) {
        return signedPreKey.getId();
    }

    public byte[] identityKeyPairToBytes(IdentityKeyPair identityKeyPair) {
        return identityKeyPair.serialize();
    }

    public IdentityKey identityKeyFromPair(IdentityKeyPair identityKeyPair) {
        return identityKeyPair.getPublicKey();
    }

    public byte[] identityKeyForBundle(IdentityKey identityKey) {
        return identityKey.getPublicKey().serialize();
    }

    public byte[] identityKeyToBytes(IdentityKey identityKey) {
        return identityKey.serialize();
    }

    public byte[] preKeyPublicKeyForBundle(ECPublicKey preKey) {
        return preKey.serialize();
    }

    public byte[] preKeyForBundle(PreKeyRecord preKeyRecord) {
        return preKeyRecord.getKeyPair().getPublicKey().serialize();
    }

    public byte[] signedPreKeyPublicForBundle(SignedPreKeyRecord signedPreKey) {
        return signedPreKey.getKeyPair().getPublicKey().serialize();
    }

    public OmemoFingerprint getFingerprintOfIdentityKey(IdentityKey identityKey) {
        if (identityKey == null) {
            return null;
        }
        String fp = identityKey.getFingerprint();
        fp = fp.replace("(byte)0x", "").replace(",", "").replace(" ", "").substring(2);
        return new OmemoFingerprint(fp);
    }

    public OmemoFingerprint getFingerprintOfIdentityKeyPair(IdentityKeyPair identityKeyPair) {
        if (identityKeyPair == null) {
            return null;
        }
        return this.getFingerprintOfIdentityKey(identityKeyPair.getPublicKey());
    }
}

