/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.signal;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.impl.JidCreate;
import org.jxmpp.stringprep.XmppStringprepException;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.InvalidKeyIdException;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.state.IdentityKeyStore;
import org.whispersystems.libsignal.state.PreKeyBundle;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.PreKeyStore;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SessionStore;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;
import org.whispersystems.libsignal.state.SignedPreKeyStore;

public class SignalOmemoStoreConnector
implements IdentityKeyStore,
SessionStore,
PreKeyStore,
SignedPreKeyStore {
    private static final Logger LOGGER = Logger.getLogger(SignalOmemoStoreConnector.class.getName());
    private final OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> omemoStore;
    private final OmemoManager omemoManager;

    public SignalOmemoStoreConnector(OmemoManager omemoManager, OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> store) {
        this.omemoManager = omemoManager;
        this.omemoStore = store;
    }

    OmemoDevice getOurDevice() {
        return this.omemoManager.getOwnDevice();
    }

    public IdentityKeyPair getIdentityKeyPair() {
        try {
            return (IdentityKeyPair)this.omemoStore.loadOmemoIdentityKeyPair(this.getOurDevice());
        }
        catch (CorruptedOmemoKeyException e) {
            LOGGER.log(Level.SEVERE, "IdentityKeyPair seems to be invalid.", e);
            return null;
        }
    }

    public int getLocalRegistrationId() {
        return 0;
    }

    public boolean saveIdentity(SignalProtocolAddress signalProtocolAddress, IdentityKey identityKey) {
        OmemoDevice device;
        try {
            device = SignalOmemoStoreConnector.asOmemoDevice(signalProtocolAddress);
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
        this.omemoStore.storeOmemoIdentityKey(this.getOurDevice(), device, (Object)identityKey);
        return true;
    }

    public boolean isTrustedIdentity(SignalProtocolAddress signalProtocolAddress, IdentityKey identityKey, IdentityKeyStore.Direction direction) {
        return true;
    }

    public PreKeyRecord loadPreKey(int i) throws InvalidKeyIdException {
        PreKeyRecord preKey = (PreKeyRecord)this.omemoStore.loadOmemoPreKey(this.getOurDevice(), i);
        if (preKey == null) {
            throw new InvalidKeyIdException("No PreKey with Id " + i + " found.");
        }
        return preKey;
    }

    public void storePreKey(int i, PreKeyRecord preKeyRecord) {
        this.omemoStore.storeOmemoPreKey(this.getOurDevice(), i, (Object)preKeyRecord);
    }

    public boolean containsPreKey(int i) {
        try {
            return this.loadPreKey(i) != null;
        }
        catch (InvalidKeyIdException e) {
            return false;
        }
    }

    public void removePreKey(int i) {
        this.omemoStore.removeOmemoPreKey(this.getOurDevice(), i);
    }

    public SessionRecord loadSession(SignalProtocolAddress signalProtocolAddress) {
        OmemoDevice device;
        try {
            device = SignalOmemoStoreConnector.asOmemoDevice(signalProtocolAddress);
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
        SessionRecord record = (SessionRecord)this.omemoStore.loadRawSession(this.getOurDevice(), device);
        if (record != null) {
            return record;
        }
        return new SessionRecord();
    }

    public List<Integer> getSubDeviceSessions(String s) {
        BareJid jid;
        try {
            jid = JidCreate.bareFrom((String)s);
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
        return new ArrayList<Integer>(this.omemoStore.loadAllRawSessionsOf(this.getOurDevice(), jid).keySet());
    }

    public void storeSession(SignalProtocolAddress signalProtocolAddress, SessionRecord sessionRecord) {
        OmemoDevice device;
        try {
            device = SignalOmemoStoreConnector.asOmemoDevice(signalProtocolAddress);
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
        this.omemoStore.storeRawSession(this.getOurDevice(), device, (Object)sessionRecord);
    }

    public boolean containsSession(SignalProtocolAddress signalProtocolAddress) {
        OmemoDevice device;
        try {
            device = SignalOmemoStoreConnector.asOmemoDevice(signalProtocolAddress);
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
        return this.omemoStore.containsRawSession(this.getOurDevice(), device);
    }

    public void deleteSession(SignalProtocolAddress signalProtocolAddress) {
        OmemoDevice device;
        try {
            device = SignalOmemoStoreConnector.asOmemoDevice(signalProtocolAddress);
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
        this.omemoStore.removeRawSession(this.getOurDevice(), device);
    }

    public void deleteAllSessions(String s) {
        BareJid jid;
        try {
            jid = JidCreate.bareFrom((String)s);
        }
        catch (XmppStringprepException e) {
            throw new AssertionError((Object)e);
        }
        this.omemoStore.removeAllRawSessionsOf(this.getOurDevice(), jid);
    }

    public SignedPreKeyRecord loadSignedPreKey(int i) throws InvalidKeyIdException {
        SignedPreKeyRecord signedPreKeyRecord = (SignedPreKeyRecord)this.omemoStore.loadOmemoSignedPreKey(this.getOurDevice(), i);
        if (signedPreKeyRecord == null) {
            throw new InvalidKeyIdException("No signed preKey with id " + i + " found.");
        }
        return signedPreKeyRecord;
    }

    public List<SignedPreKeyRecord> loadSignedPreKeys() {
        TreeMap signedPreKeyRecordHashMap = this.omemoStore.loadOmemoSignedPreKeys(this.getOurDevice());
        return new ArrayList<SignedPreKeyRecord>(signedPreKeyRecordHashMap.values());
    }

    public void storeSignedPreKey(int i, SignedPreKeyRecord signedPreKeyRecord) {
        this.omemoStore.storeOmemoSignedPreKey(this.getOurDevice(), i, (Object)signedPreKeyRecord);
    }

    public boolean containsSignedPreKey(int i) {
        try {
            return this.loadSignedPreKey(i) != null;
        }
        catch (InvalidKeyIdException e) {
            LOGGER.log(Level.WARNING, "containsSignedPreKey has failed: " + e.getMessage());
            return false;
        }
    }

    public void removeSignedPreKey(int i) {
        this.omemoStore.removeOmemoSignedPreKey(this.getOurDevice(), i);
    }

    private static OmemoDevice asOmemoDevice(SignalProtocolAddress address) throws XmppStringprepException {
        return new OmemoDevice(JidCreate.bareFrom((String)address.getName()), address.getDeviceId());
    }

    public static SignalProtocolAddress asAddress(OmemoDevice device) {
        return new SignalProtocolAddress(device.getJid().toString(), device.getDeviceId());
    }
}

