/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import org.jivesoftware.smackx.omemo.OmemoStore;
import org.jivesoftware.smackx.omemo.OmemoStoreTest;
import org.jivesoftware.smackx.omemo.signal.SignalCachingOmemoStore;
import org.jivesoftware.smackx.omemo.signal.SignalFileBasedOmemoStore;
import org.jivesoftware.smackx.omemo.signal.SignalOmemoKeyUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.jxmpp.stringprep.XmppStringprepException;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.SessionCipher;
import org.whispersystems.libsignal.SignalProtocolAddress;
import org.whispersystems.libsignal.ecc.ECPublicKey;
import org.whispersystems.libsignal.state.PreKeyBundle;
import org.whispersystems.libsignal.state.PreKeyRecord;
import org.whispersystems.libsignal.state.SessionRecord;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;

@RunWith(value=Parameterized.class)
public class SignalOmemoStoreTest
extends OmemoStoreTest<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> {
    public SignalOmemoStoreTest(OmemoStore<IdentityKeyPair, IdentityKey, PreKeyRecord, SignedPreKeyRecord, SessionRecord, SignalProtocolAddress, ECPublicKey, PreKeyBundle, SessionCipher> store) throws XmppStringprepException {
        super(store);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() throws IOException {
        TemporaryFolder temp = SignalOmemoStoreTest.initStaticTemp();
        return Arrays.asList({new SignalFileBasedOmemoStore(temp.newFolder("sigFileBased"))}, {new SignalCachingOmemoStore()}, {new SignalCachingOmemoStore((OmemoStore)new SignalFileBasedOmemoStore(temp.newFolder("cachingSigFileBased")))});
    }

    @Test
    public void keyUtilTest() {
        Assert.assertTrue((boolean)(this.store.keyUtil() instanceof SignalOmemoKeyUtil));
    }
}

