/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import junit.framework.TestCase;
import org.jivesoftware.smack.DummyConnection;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.packet.StanzaBuilder;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smackx.omemo.OmemoManager;
import org.jivesoftware.smackx.omemo.element.OmemoElement;
import org.jivesoftware.smackx.omemo.provider.OmemoVAxolotlProvider;
import org.jivesoftware.smackx.omemo.signal.SignalOmemoService;
import org.junit.Test;

public class SignalOmemoManagerTest
extends SmackTestSuite {
    @Test
    public void instantiationTest() {
        SignalOmemoService.acknowledgeLicense();
        SignalOmemoService.setup();
        DummyConnection dummy = new DummyConnection();
        DummyConnection silly = new DummyConnection();
        OmemoManager a = OmemoManager.getInstanceFor((XMPPConnection)dummy, (Integer)123);
        OmemoManager b = OmemoManager.getInstanceFor((XMPPConnection)dummy, (Integer)234);
        OmemoManager c = OmemoManager.getInstanceFor((XMPPConnection)silly, (Integer)123);
        OmemoManager d = OmemoManager.getInstanceFor((XMPPConnection)dummy, (Integer)123);
        TestCase.assertNotNull((Object)a);
        TestCase.assertNotNull((Object)b);
        TestCase.assertNotNull((Object)c);
        TestCase.assertNotNull((Object)d);
        TestCase.assertEquals((Object)123, (Object)a.getDeviceId());
        TestCase.assertEquals((Object)234, (Object)b.getDeviceId());
        TestCase.assertFalse((a == b ? 1 : 0) != 0);
        TestCase.assertFalse((a == c ? 1 : 0) != 0);
        TestCase.assertFalse((b == c ? 1 : 0) != 0);
        TestCase.assertTrue((a == d ? 1 : 0) != 0);
    }

    @Test
    public void randomDeviceIdTest() {
        int a = OmemoManager.randomDeviceId();
        int b = OmemoManager.randomDeviceId();
        TestCase.assertNotSame((Object)a, (Object)b);
        TestCase.assertTrue((a > 0 ? 1 : 0) != 0);
        TestCase.assertTrue((b > 0 ? 1 : 0) != 0);
    }

    @Test
    public void stanzaRecognitionTest() throws Exception {
        String omemoXML = "<encrypted xmlns='eu.siacs.conversations.axolotl'><header sid='1009'><key rid='1337'>MwohBfRqBm2atj3fT0/KUDg59Cnvfpgoe/PLNIu1xgSXujEZEAAYACIwKh6TTC7VBQZcCcKnQlO+6s1GQ9DIRKH4JU7XrJ+JJnkPUwJ4VLSeOEQD7HmFbhQPTLZO0u/qlng=</key><iv>sN0amy4e2NBrlb4G/OjNIQ==</iv></header><payload>4xVUAeg4M0Mhk+5n3YG1x12Dw/cYTc0Z</payload></encrypted>";
        OmemoElement omemoElement = (OmemoElement)new OmemoVAxolotlProvider().parse(TestUtils.getParser((String)omemoXML));
        Message m = ((MessageBuilder)StanzaBuilder.buildMessage().addExtension((XmlElement)omemoElement)).build();
        Message n = StanzaBuilder.buildMessage().build();
        TestCase.assertTrue((boolean)OmemoManager.stanzaContainsOmemoElement((Stanza)m));
        TestCase.assertFalse((boolean)OmemoManager.stanzaContainsOmemoElement((Stanza)n));
    }
}

