/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import junit.framework.TestCase;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smackx.omemo.exceptions.CorruptedOmemoKeyException;
import org.jivesoftware.smackx.omemo.signal.SignalOmemoKeyUtil;
import org.junit.Test;
import org.whispersystems.libsignal.IdentityKey;
import org.whispersystems.libsignal.IdentityKeyPair;
import org.whispersystems.libsignal.state.SignedPreKeyRecord;

public class LegacySignalOmemoKeyUtilTest
extends SmackTestSuite {
    private final SignalOmemoKeyUtil keyUtil = new SignalOmemoKeyUtil();

    @Test
    public void omemoIdentityKeyPairSerializationTest() throws CorruptedOmemoKeyException {
        IdentityKeyPair ikp = this.keyUtil.generateOmemoIdentityKeyPair();
        byte[] bytes = this.keyUtil.identityKeyPairToBytes(ikp);
        TestCase.assertNotNull((String)"serialized identityKeyPair must not be null.", (Object)bytes);
        TestCase.assertNotSame((String)"serialized identityKeyPair must not be of length 0.", (Object)0, (Object)bytes.length);
        IdentityKeyPair ikp2 = this.keyUtil.identityKeyPairFromBytes(bytes);
        TestCase.assertTrue((String)"Deserialized IdentityKeyPairs PublicKey must equal the originals one.", (boolean)ikp.getPublicKey().equals((Object)ikp2.getPublicKey()));
    }

    @Test
    public void omemoIdentityKeySerializationTest() {
        IdentityKey k = this.keyUtil.generateOmemoIdentityKeyPair().getPublicKey();
        try {
            TestCase.assertEquals((String)"Deserialized IdentityKey must equal the original one.", (Object)k, (Object)this.keyUtil.identityKeyFromBytes(this.keyUtil.identityKeyToBytes(k)));
        }
        catch (CorruptedOmemoKeyException e) {
            TestCase.fail((String)("Caught exception while serializing and deserializing identityKey (" + String.valueOf((Object)e) + "): " + e.getMessage()));
        }
    }

    @Test
    public void generateOmemoSignedPreKeyTest() {
        IdentityKeyPair ikp = this.keyUtil.generateOmemoIdentityKeyPair();
        try {
            SignedPreKeyRecord spk = this.keyUtil.generateOmemoSignedPreKey(ikp, 1);
            TestCase.assertNotNull((String)"SignedPreKey must not be null.", (Object)spk);
            TestCase.assertEquals((String)"SignedPreKeyId must match.", (int)1, (int)spk.getId());
            TestCase.assertEquals((String)"singedPreKeyId must match here also.", (int)1, (int)this.keyUtil.signedPreKeyIdFromKey(spk));
        }
        catch (CorruptedOmemoKeyException e) {
            TestCase.fail((String)("Caught an exception while generating signedPreKey (" + String.valueOf((Object)e) + "): " + e.getMessage()));
        }
    }

    @Test
    public void getFingerprintTest() {
        IdentityKeyPair ikp = this.keyUtil.generateOmemoIdentityKeyPair();
        IdentityKey ik = ikp.getPublicKey();
        TestCase.assertTrue((String)"Length of fingerprint must be 64.", (this.keyUtil.getFingerprintOfIdentityKey(ik).length() == 64 ? 1 : 0) != 0);
    }
}

