/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.omemo;

import java.util.ArrayList;
import org.jivesoftware.smack.test.util.SmackTestSuite;
import org.jivesoftware.smack.test.util.TestUtils;
import org.jivesoftware.smack.util.stringencoder.Base64;
import org.jivesoftware.smackx.omemo.element.OmemoElement;
import org.jivesoftware.smackx.omemo.element.OmemoVAxolotlElement;
import org.jivesoftware.smackx.omemo.provider.OmemoVAxolotlProvider;
import org.jivesoftware.smackx.omemo.util.OmemoMessageBuilder;
import org.junit.Assert;
import org.junit.Test;

public class OmemoVAxolotlElementTest
extends SmackTestSuite {
    @Test
    public void serializationTest() throws Exception {
        byte[] payload = "This is payload.".getBytes("UTF-8");
        int keyId1 = 8;
        int keyId2 = 33333;
        byte[] keyData1 = "KEYDATA".getBytes("UTF-8");
        byte[] keyData2 = "DATAKEY".getBytes("UTF-8");
        int sid = 12131415;
        byte[] iv = OmemoMessageBuilder.generateIv();
        ArrayList<OmemoElement.OmemoHeader.Key> keys = new ArrayList<OmemoElement.OmemoHeader.Key>();
        keys.add(new OmemoElement.OmemoHeader.Key(keyData1, keyId1));
        keys.add(new OmemoElement.OmemoHeader.Key(keyData2, keyId2, true));
        OmemoElement.OmemoHeader header = new OmemoElement.OmemoHeader(sid, keys, iv);
        OmemoVAxolotlElement element = new OmemoVAxolotlElement(header, payload);
        String expected = "<encrypted xmlns='eu.siacs.conversations.axolotl'><header sid='12131415'><key rid='8'>" + Base64.encodeToString((byte[])keyData1) + "</key>" + "<key prekey='true' rid='33333'>" + Base64.encodeToString((byte[])keyData2) + "</key>" + "<iv>" + Base64.encodeToString((byte[])iv) + "</iv>" + "</header>" + "<payload>" + Base64.encodeToString((byte[])payload) + "</payload>" + "</encrypted>";
        String actual = element.toXML().toString();
        Assert.assertEquals((String)"Serialized xml of OmemoElement must match.", (Object)expected, (Object)actual);
        OmemoVAxolotlElement parsed = (OmemoVAxolotlElement)new OmemoVAxolotlProvider().parse(TestUtils.getParser((String)actual));
        Assert.assertEquals((String)"Parsed OmemoElement must equal the original.", (Object)element.toXML().toString(), (Object)parsed.toXML().toString());
    }
}

