/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.omemo;

import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import junit.framework.TestCase;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smackx.omemo.exceptions.CryptoFailedException;
import org.jivesoftware.smackx.omemo.internal.CipherAndAuthTag;
import org.jivesoftware.smackx.omemo.internal.CiphertextTuple;
import org.jivesoftware.smackx.omemo.internal.ClearTextMessage;
import org.jivesoftware.smackx.omemo.internal.IdentityKeyWrapper;
import org.jivesoftware.smackx.omemo.internal.OmemoDevice;
import org.jivesoftware.smackx.omemo.internal.OmemoMessageInformation;
import org.jivesoftware.smackx.omemo.util.OmemoMessageBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

public class WrapperObjectsTest {
    @Test
    public void identityKeyWrapperTest() {
        Object pseudoKey = new Object();
        IdentityKeyWrapper wrapper = new IdentityKeyWrapper(pseudoKey);
        TestCase.assertEquals((Object)pseudoKey, (Object)wrapper.getIdentityKey());
    }

    @Test
    public void ciphertextTupleTest() {
        byte[] c = OmemoMessageBuilder.generateIv();
        CiphertextTuple c1 = new CiphertextTuple(c, 1);
        TestCase.assertTrue((boolean)c1.isPreKeyMessage());
        Assert.assertArrayEquals((byte[])c, (byte[])c1.getCiphertext());
        TestCase.assertEquals((int)1, (int)c1.getMessageType());
        CiphertextTuple c2 = new CiphertextTuple(c, 0);
        Assert.assertFalse((boolean)c2.isPreKeyMessage());
        TestCase.assertEquals((int)0, (int)c2.getMessageType());
    }

    @Test
    public void clearTextMessageTest() throws Exception {
        Object pseudoKey = new Object();
        IdentityKeyWrapper wrapper = new IdentityKeyWrapper(pseudoKey);
        BareJid senderJid = JidCreate.bareFrom((String)"bob@server.tld");
        OmemoDevice sender = new OmemoDevice(senderJid, 1234);
        OmemoMessageInformation information = new OmemoMessageInformation(wrapper, sender, OmemoMessageInformation.CARBON.NONE);
        TestCase.assertTrue((String)"OmemoInformation must state that the message is an OMEMO message.", (boolean)information.isOmemoMessage());
        TestCase.assertEquals((Object)OmemoMessageInformation.CARBON.NONE, (Object)information.getCarbon());
        TestCase.assertEquals((Object)sender, (Object)information.getSenderDevice());
        TestCase.assertEquals((Object)wrapper, (Object)information.getSenderIdentityKey());
        String body = "Decrypted Body";
        Message message = new Message((Jid)senderJid, body);
        ClearTextMessage c = new ClearTextMessage(body, message, information);
        TestCase.assertEquals((Object)message, (Object)c.getOriginalMessage());
        TestCase.assertEquals((Object)information, (Object)c.getMessageInformation());
        TestCase.assertEquals((String)body, (String)c.getBody());
    }

    @Test
    public void cipherAndAuthTagTest() throws NoSuchAlgorithmException, CryptoFailedException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] key = OmemoMessageBuilder.generateKey();
        byte[] iv = OmemoMessageBuilder.generateIv();
        byte[] authTag = OmemoMessageBuilder.generateIv();
        CipherAndAuthTag cat = new CipherAndAuthTag(key, iv, authTag);
        Assert.assertNotNull((Object)cat.getCipher());
        Assert.assertArrayEquals((byte[])key, (byte[])cat.getKey());
        Assert.assertArrayEquals((byte[])iv, (byte[])cat.getIv());
        Assert.assertArrayEquals((byte[])authTag, (byte[])cat.getAuthTag());
    }
}

