/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo;

import java.io.File;

public final class OmemoConfiguration {
    private static boolean IGNORE_STALE_DEVICES = true;
    private static int IGNORE_STALE_DEVICE_AFTER_HOURS = 168;
    private static boolean DELETE_STALE_DEVICES = true;
    private static int DELETE_STALE_DEVICE_AFTER_HOURS = 672;
    private static boolean RENEW_OLD_SIGNED_PREKEYS = false;
    private static int RENEW_OLD_SIGNED_PREKEYS_AFTER_HOURS = 168;
    private static int MAX_NUMBER_OF_STORED_SIGNED_PREKEYS = 4;
    private static boolean ADD_OMEMO_HINT_BODY = true;
    private static boolean ADD_EME_ENCRYPTION_HINT = true;
    private static boolean ADD_MAM_STORAGE_HINT = true;
    private static File FILE_BASED_OMEMO_STORE_DEFAULT_PATH = null;

    public static void setIgnoreStaleDevices(boolean ignore) {
        IGNORE_STALE_DEVICES = ignore;
    }

    public static boolean getIgnoreStaleDevices() {
        return IGNORE_STALE_DEVICES;
    }

    public static void setIgnoreStaleDevicesAfterHours(int hours) {
        if (hours <= 0) {
            throw new IllegalArgumentException("Hours must be greater than 0.");
        }
        IGNORE_STALE_DEVICE_AFTER_HOURS = hours;
    }

    public static int getIgnoreStaleDevicesAfterHours() {
        return IGNORE_STALE_DEVICE_AFTER_HOURS;
    }

    public static void setDeleteStaleDevices(boolean delete) {
        DELETE_STALE_DEVICES = delete;
    }

    public static boolean getDeleteStaleDevices() {
        return DELETE_STALE_DEVICES;
    }

    public static void setDeleteStaleDevicesAfterHours(int hours) {
        if (hours <= 0) {
            throw new IllegalArgumentException("Hours must be greater than 0.");
        }
        DELETE_STALE_DEVICE_AFTER_HOURS = hours;
    }

    public static int getDeleteStaleDevicesAfterHours() {
        return DELETE_STALE_DEVICE_AFTER_HOURS;
    }

    public static void setRenewOldSignedPreKeys(boolean renew) {
        RENEW_OLD_SIGNED_PREKEYS = renew;
    }

    public static boolean getRenewOldSignedPreKeys() {
        return RENEW_OLD_SIGNED_PREKEYS;
    }

    public static void setRenewOldSignedPreKeysAfterHours(int hours) {
        if (hours <= 0) {
            throw new IllegalArgumentException("Hours must be greater than 0.");
        }
        RENEW_OLD_SIGNED_PREKEYS_AFTER_HOURS = hours;
    }

    public static int getRenewOldSignedPreKeysAfterHours() {
        return RENEW_OLD_SIGNED_PREKEYS_AFTER_HOURS;
    }

    public static void setMaxNumberOfStoredSignedPreKeys(int number) {
        if (number <= 0) {
            throw new IllegalArgumentException("Number must be greater than 0.");
        }
        MAX_NUMBER_OF_STORED_SIGNED_PREKEYS = number;
    }

    public static int getMaxNumberOfStoredSignedPreKeys() {
        return MAX_NUMBER_OF_STORED_SIGNED_PREKEYS;
    }

    public static void setAddOmemoHintBody(boolean addHint) {
        ADD_OMEMO_HINT_BODY = addHint;
    }

    public static boolean getAddOmemoHintBody() {
        return ADD_OMEMO_HINT_BODY;
    }

    public static void setAddEmeEncryptionHint(boolean addHint) {
        ADD_EME_ENCRYPTION_HINT = addHint;
    }

    public static boolean getAddEmeEncryptionHint() {
        return ADD_EME_ENCRYPTION_HINT;
    }

    public static void setAddMAMStorageProcessingHint(boolean addStorageHint) {
        ADD_MAM_STORAGE_HINT = addStorageHint;
    }

    public static boolean getAddMAMStorageProcessingHint() {
        return ADD_MAM_STORAGE_HINT;
    }

    public static void setFileBasedOmemoStoreDefaultPath(File path) {
        FILE_BASED_OMEMO_STORE_DEFAULT_PATH = path;
    }

    public static File getFileBasedOmemoStoreDefaultPath() {
        return FILE_BASED_OMEMO_STORE_DEFAULT_PATH;
    }
}

