/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.omemo.element;

import java.util.ArrayList;
import org.jivesoftware.smack.packet.Element;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smack.util.stringencoder.Base64;

public abstract class OmemoElement
implements ExtensionElement {
    public static final int TYPE_OMEMO_PREKEY_MESSAGE = 1;
    public static final int TYPE_OMEMO_MESSAGE = 0;
    public static final String ENCRYPTED = "encrypted";
    public static final String HEADER = "header";
    public static final String SID = "sid";
    public static final String KEY = "key";
    public static final String RID = "rid";
    public static final String PREKEY = "prekey";
    public static final String IV = "iv";
    public static final String PAYLOAD = "payload";
    protected final OmemoHeader header;
    protected final byte[] payload;

    public OmemoElement(OmemoHeader header, byte[] payload) {
        this.header = (OmemoHeader)Objects.requireNonNull((Object)header);
        this.payload = payload;
    }

    public OmemoHeader getHeader() {
        return this.header;
    }

    public byte[] getPayload() {
        if (this.payload == null) {
            return null;
        }
        return (byte[])this.payload.clone();
    }

    public boolean isKeyTransportElement() {
        return this.payload == null;
    }

    public boolean isMessageElement() {
        return this.payload != null;
    }

    public static class OmemoHeader
    implements NamedElement {
        private final int sid;
        private final ArrayList<Key> keys;
        private final byte[] iv;

        public OmemoHeader(int sid, ArrayList<Key> keys, byte[] iv) {
            this.sid = sid;
            this.keys = keys;
            this.iv = iv;
        }

        public int getSid() {
            return this.sid;
        }

        public ArrayList<Key> getKeys() {
            return new ArrayList<Key>(this.keys);
        }

        public byte[] getIv() {
            return this.iv != null ? (byte[])this.iv.clone() : null;
        }

        public String getElementName() {
            return OmemoElement.HEADER;
        }

        public CharSequence toXML() {
            XmlStringBuilder sb = new XmlStringBuilder((NamedElement)this);
            sb.attribute(OmemoElement.SID, this.getSid()).rightAngleBracket();
            for (Key k : this.getKeys()) {
                sb.element((Element)k);
            }
            sb.openElement(OmemoElement.IV).append((CharSequence)Base64.encodeToString((byte[])this.getIv())).closeElement(OmemoElement.IV);
            return sb.closeElement((NamedElement)this);
        }

        public static class Key
        implements NamedElement {
            final byte[] data;
            final int id;
            final boolean preKey;

            public Key(byte[] data, int id) {
                this.data = data;
                this.id = id;
                this.preKey = false;
            }

            public Key(byte[] data, int id, boolean preKey) {
                this.data = data;
                this.id = id;
                this.preKey = preKey;
            }

            public int getId() {
                return this.id;
            }

            public byte[] getData() {
                return this.data;
            }

            public boolean isPreKey() {
                return this.preKey;
            }

            public String toString() {
                return Integer.toString(this.id);
            }

            public String getElementName() {
                return OmemoElement.KEY;
            }

            public CharSequence toXML() {
                XmlStringBuilder sb = new XmlStringBuilder((NamedElement)this);
                if (this.isPreKey()) {
                    sb.attribute(OmemoElement.PREKEY, true);
                }
                sb.attribute(OmemoElement.RID, this.getId());
                sb.rightAngleBracket();
                sb.append((CharSequence)Base64.encodeToString((byte[])this.getData()));
                sb.closeElement((NamedElement)this);
                return sb;
            }
        }
    }
}

